<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Filesystem\File as JFile;
use Joomla\CMS\Filesystem\Folder as JFolder;
use RegularLabs\Component\Conditions\Administrator\Helper\ConvertAssignments as ConditionsConvertAssignments;

class Com_ReReplacerInstallerScript
{
    public function postflight($install_type, $adapter)
    {
        if ( ! in_array($install_type, ['install', 'update']))
        {
            return true;
        }

        self::createTable();
        self::fixColumns();
        self::deleteJoomla3Files();


        return true;
    }

    private static function convertAssignmentsToConditions()
    {
    }

    private static function createTable()
    {
        $db = JFactory::getDbo();

        $query = "CREATE TABLE IF NOT EXISTS `#__rereplacer` (
            `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
            `name` VARCHAR(100) NOT NULL,
            `description` TEXT NOT NULL,
            `category` VARCHAR(50) NOT NULL,
            `color` VARCHAR(8) NULL DEFAULT NULL,
            `search` TEXT NOT NULL,
            `replace` TEXT NOT NULL,
            `area` TEXT NOT NULL,
            `params` TEXT NOT NULL,
            `published` TINYINT(1) NOT NULL DEFAULT '0',
            `ordering` INT NOT NULL DEFAULT '0',
            `checked_out` INT UNSIGNED DEFAULT NULL,
            `checked_out_time` datetime NULL DEFAULT NULL,
            PRIMARY KEY  (`id`),
            KEY `id` (`id`,`published`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        $db->setQuery($query);
        $db->execute();

        $db->setQuery('ALTER TABLE `#__rereplacer` MODIFY `checked_out` INT UNSIGNED DEFAULT NULL;');
        $db->execute();

        $db->setQuery('ALTER TABLE `#__rereplacer` MODIFY `checked_out_time` datetime NULL DEFAULT NULL;');
        $db->execute();

        $db->setQuery('UPDATE `#__rereplacer` SET `checked_out` = NULL WHERE `checked_out` = 0;');
        $db->execute();

        $db->setQuery('UPDATE `#__rereplacer` SET `checked_out_time` = NULL WHERE CAST(`checked_out_time` AS CHAR(20)) = \'0000-00-00 00:00:00\';');
        $db->execute();
    }

    private static function delete($files = [])
    {
        foreach ($files as $file)
        {
            if (is_dir($file))
            {
                JFolder::delete($file);
            }

            if (is_file($file))
            {
                JFile::delete($file);
            }
        }
    }

    private static function deleteJoomla3Files()
    {
        self::delete(
            [
                JPATH_ADMINISTRATOR . '/components/com_rereplacer/controllers',
                JPATH_ADMINISTRATOR . '/components/com_rereplacer/helpers',
                JPATH_ADMINISTRATOR . '/components/com_rereplacer/models',
                JPATH_ADMINISTRATOR . '/components/com_rereplacer/views',
                JPATH_ADMINISTRATOR . '/components/com_rereplacer/tables',
                JPATH_ADMINISTRATOR . '/components/com_rereplacer/controller.php',
                JPATH_ADMINISTRATOR . '/components/com_rereplacer/item_params.xml',
                JPATH_ADMINISTRATOR . '/components/com_rereplacer/rereplacer.php',
            ]
        );
    }

    private static function fixColumns()
    {
        $db = JFactory::getDbo();

        $query = 'SHOW COLUMNS FROM `#__rereplacer`';
        $db->setQuery($query);

        $columns = $db->loadColumn();

        if ( ! in_array('color', $columns))
        {
            $query = "ALTER TABLE `#__rereplacer` ADD `color` VARCHAR(8) NULL DEFAULT NULL AFTER `category`;";
            $db->setQuery($query);
            $db->execute();
        }
    }
}
