<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\ReReplacer\Administrator\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Router\Route;

/**
 * ReReplacer master display controller.
 */
class DisplayController extends BaseController
{
    /**
     * @var        string    The default view.
     */
    protected $default_view = 'items';

    /**
     * @param boolean $cachable  If true, the view output will be cached.
     * @param mixed   $urlparams An array of safe URL parameters and their variable types, for valid values see {@link \JFilterInput::clean()}.
     *
     * @return  static|boolean     This object to support chaining or false on failure.
     */
    public function display($cachable = false, $urlparams = false)
    {
        $view   = $this->input->get('view', 'items');
        $layout = $this->input->get('layout', 'default');
        $id     = $this->input->getInt('id');

        // Check for edit form.
        if ($view == 'item' && $layout == 'edit' && ! $this->checkEditId('com_rereplacer.edit.item', $id))
        {
            // Somehow the person just went to the form - we don't allow that.
            $this->setMessage(Text::sprintf('JLIB_APPLICATION_ERROR_UNHELD_ID', $id), 'error');
            $this->setRedirect(Route::_('index.php?option=com_rereplacer&view=items', false));

            return false;
        }

        return parent::display();
    }
}
