<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\ReReplacer\Administrator\Helper;

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;

class Helper
{

    public static $extension = 'com_rereplacer';

    /**
     * Determines if the plugin for ReReplacer to work is enabled.
     *
     * @return    boolean
     */
    public static function isEnabled()
    {
        $db = JFactory::getDbo();

        $query = $db->getQuery(true)
            ->select($db->quote('enabled'))
            ->from($db->quoteName('#__extensions'))
            ->where($db->quoteName('folder') . ' = ' . $db->quote('system'))
            ->where($db->quoteName('element') . ' = ' . $db->quote('rereplacer'));

        $db->setQuery($query);

        return (boolean) $db->loadResult();
    }
}
