<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\ReReplacer\Administrator\Table;

use Exception;
use Joomla\CMS\Language\Text as JText;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die;

class ItemTable extends Table
{
    /**
     * @param DatabaseDriver $db Database object.
     */
    public function __construct(DatabaseDriver $db)
    {
        parent::__construct('#__rereplacer', 'id', $db);
    }

    /**
     * Overloaded check function
     *
     * @return  boolean
     *
     * @since   1.6
     */
    public function check()
    {
        try
        {
            parent::check();
        }
        catch (Exception $e)
        {
            $this->setError($e->getMessage());

            return false;
        }

        $this->name   = trim($this->name);
        $this->search = trim($this->search);

        // Check for valid name
        if (empty($this->name))
        {
            $this->setError(JText::_('RR_THE_ITEM_MUST_HAVE_A_NAME'));

            return false;
        }


        if (trim($this->search) == '')
        {
            $this->setError(JText::_('RR_THE_ITEM_MUST_HAVE_SOMETHING_TO_SEARCH_FOR'));

            return false;
        }

        return true;
    }
}
