<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\ReReplacer\Administrator\View\Item;

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Form\Form as JForm;
use Joomla\CMS\Helper\ContentHelper as ContentHelper;
use Joomla\CMS\Language\Text as JText;
use Joomla\CMS\MVC\View\GenericDataException as JGenericDataException;
use Joomla\CMS\MVC\View\HtmlView as JHtmlView;
use Joomla\CMS\Toolbar\Toolbar as JToolbar;
use Joomla\CMS\Toolbar\ToolbarHelper as JToolbarHelper;
use RegularLabs\Library\Parameters as RL_Parameters;

defined('_JEXEC') or die;

/**
 * Item View
 */
class HtmlView extends JHtmlView
{
    /**
     * @var    object
     */
    protected $config;
    /**
     * @var  JForm
     */
    protected $form;
    /**
     * @var  object
     */
    protected $item;
    /**
     * @var    object
     */
    protected $state;

    /**
     * @param string $tpl The name of the template file to parse; automatically searches through the template paths.
     *
     * @return  mixed  False if unsuccessful, otherwise void.
     */
    public function display($tpl = null)
    {
        $this->form   = $this->get('Form');
        $this->item   = $this->get('Item');
        $this->state  = $this->get('State');
        $this->config = RL_Parameters::getComponent('rereplacer', $this->state->params);

        // Check for errors.
        if (count($errors = $this->get('Errors')))
        {
            throw new JGenericDataException(implode("\n", $errors), 500);
        }

        $this->addToolbar();
        parent::display($tpl);
    }

    /**
     * @return  void
     */
    protected function addToolbar()
    {
        $isNew = ($this->item->id == 0);
        $canDo = ContentHelper::getActions('com_rereplacer');

        JFactory::getApplication()->input->set('hidemainmenu', true);

        JToolbarHelper::title(JText::_('REREPLACER') . ': ' . JText::_('RL_ITEM'), 'rereplacer icon-reglab');

        $toolbar        = JToolbar::getInstance('toolbar');
        $toolbarButtons = [];

        // If not checked out, can save the item.
        if ($canDo->get('core.edit'))
        {
            JToolbarHelper::apply('item.apply');
            $toolbarButtons[] = ['save', 'item.save'];
        }

        /**
         * This component does not support Save as Copy due to uniqueness checks.
         * While it can be done, it causes too much confusion if the user does
         * not change the Old URL.
         */
        if ($canDo->get('core.edit') && $canDo->get('core.create'))
        {
            $toolbarButtons[] = ['save2new', 'item.save2new'];
        }

        if ( ! $isNew && $canDo->get('core.create'))
        {
            $toolbarButtons[] = ['save2copy', 'item.save2copy'];
        }

        JToolbarHelper::saveGroup(
            $toolbarButtons,
            'btn-success'
        );

        if (empty($this->item->id))
        {
            JToolbarHelper::cancel('item.cancel');
        }
        else
        {
            JToolbarHelper::cancel('item.cancel', 'JTOOLBAR_CLOSE');
        }

        $toolbar->appendButton('Popup', 'help', 'RL_DYNAMIC_TAGS', 'index.php?option=com_rereplacer&view=item&layout=dynamic_tags&tmpl=component', 800, 600, '', '', '', JText::_('RL_DYNAMIC_TAGS'));
    }
}
