<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Language\Text as JText;
use RegularLabs\Library\Alias as RL_Alias;
use RegularLabs\Library\Date as RL_Date;

$user    = JFactory::getApplication()->getIdentity() ?: JFactory::getUser();
$contact = (object) [];

$db         = JFactory::getDbo();
$table_name = $db->getPrefix() . 'contact_details';

if (in_array($table_name, $db->getTableList()))
{
    $query = 'SHOW FIELDS FROM ' . $db->quoteName($table_name);
    $db->setQuery($query);
    $columns = $db->loadColumn();

    if (in_array('misc', $columns))
    {
        $query = $db->getQuery(true)
            ->select('c.misc')
            ->from('#__contact_details as c')
            ->where('c.user_id = ' . (int) $user->id);
        $db->setQuery($query);
        $contact = $db->loadObject();
    }
}

$yes = '<td class="text-center text-success"><span class="icon-checkmark" aria-hidden="true"></span> ' . JText::_('JYES') . '</td>';
$no  = '<td class="text-center text-danger" class="text-muted"><span class="icon-cancel" aria-hidden="true"></span> ' . JText::_('JNO') . '</td>';

?>
<div class="alert alert-danger">
    <?php echo JText::_('RL_ONLY_AVAILABLE_IN_PRO'); ?>
</div>

<p><?php echo JText::_('RR_DYNAMIC_TAGS_DESC'); ?></p>

<table class="table table-striped">
    <thead>
        <tr>
            <th class="fw-bold" width="50%">
                <?php echo JText::_('RL_INPUT_SYNTAX'); ?>
            </th>
            <th class="fw-bold">
                <span><?php echo JText::_('RL_OUTPUT_EXAMPLE'); ?></span>
            </th>
            <th class="fw-bold">
                <span><?php echo JText::_('JGLOBAL_DESCRIPTION'); ?></span>
            </th>
            <th class="text-center fw-bold">
                <span rel="tooltip" title="<?php echo JText::_('RR_USE_IN_SEARCH'); ?>"><?php echo JText::_('RR_SEARCH'); ?></span>
            </th>
            <th class="text-center fw-bold">
                <span rel="tooltip" title="<?php echo JText::_('RR_USE_IN_REPLACE'); ?>"><?php echo JText::_('RR_REPLACE'); ?></span>
            </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><code>[[comma]]</code></td>
            <td>,</td>
            <td><?php echo JText::_('RR_USE_INSTEAD_OF_A_COMMA,RR_TREAT_AS_LIST'); ?></td>
            <?php echo $yes; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[space]]</code></td>
            <td></td>
            <td><?php echo JText::_('RR_USE_FOR_LEADING_OR_TRAILING_SPACES'); ?></td>
            <?php echo $yes; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[user:id]]</code></td>
            <td><?php echo $user->id; ?></td>
            <td>
                <?php echo JText::_('RL_DYNAMIC_TAG_USER_ID'); ?>
                <br><em class="text-muted"><?php echo JText::_('RL_DYNAMIC_TAG_USER_TAG_DESC'); ?></em>
            </td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[user:username]]</code></td>
            <td><?php echo $user->username; ?></td>
            <td>
                <?php echo JText::_('RL_DYNAMIC_TAG_USER_USERNAME'); ?>
                <br><em class="text-muted"><?php echo JText::_('RL_DYNAMIC_TAG_USER_TAG_DESC'); ?></em>
            </td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[user:name]]</code></td>
            <td><?php echo $user->name; ?></td>
            <td>
                <?php echo JText::_('RL_DYNAMIC_TAG_USER_NAME'); ?>
                <br><em class="text-muted"><?php echo JText::_('RL_DYNAMIC_TAG_USER_TAG_DESC'); ?></em>
            </td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[user:misc]]</code></td>
            <td><?php echo $contact->misc ?? ''; ?></td>
            <td>
                <?php echo JText::_('RL_DYNAMIC_TAG_USER_OTHER'); ?>
                <br><em class="text-muted"><?php echo JText::_('RL_DYNAMIC_TAG_USER_TAG_DESC'); ?></em>
            </td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[article:id]]</code></td>
            <td>123</td>
            <td>
                <?php echo JText::_('RL_DYNAMIC_TAG_ARTICLE_ID'); ?>
                <br><em class="text-muted">
                    <?php echo JText::_('RR_ONLY_AVAILABLE_IN_SEARCH_AREA,RR_ENABLE_IN_AREA,RR_AREA_CONTENT'); ?>
                </em>
            </td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[article:title]]</code></td>
            <td>My Article</td>
            <td>
                <?php echo JText::_('RL_DYNAMIC_TAG_ARTICLE_TITLE'); ?>
                <br><em class="text-muted">
                    <?php echo JText::_('RR_ONLY_AVAILABLE_IN_SEARCH_AREA,RR_ENABLE_IN_AREA,RR_AREA_CONTENT'); ?>
                </em>
            </td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[article:alias]]</code></td>
            <td>my-article</td>
            <td>
                <?php echo JText::_('RL_DYNAMIC_TAG_ARTICLE_OTHER'); ?>
                <br><em class="text-muted">
                    <?php echo JText::_('RR_ONLY_AVAILABLE_IN_SEARCH_AREA,RR_ENABLE_IN_AREA,RR_AREA_CONTENT'); ?>
                </em>
            </td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>
                    [[date:%A, %d %B %Y]]<br>
                    [[date:%Y-%m-%d]]
                </code></td>
            <td>
                <?php echo date(RL_Date::strftimeToDateFormat('%A, %d %B %Y')); ?><br>
                <?php echo date(RL_Date::strftimeToDateFormat('%Y-%m-%d')); ?>
            </td>
            <td><?php echo JText::sprintf('RL_DYNAMIC_TAG_DATE', '<a href="http://www.php.net/manual/function.strftime.php" target="_blank">', '</a>', '<span>[[date: %A, %d %B %Y]]</span>'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>
                    [[random:0-100]]<br>
                    [[random:1000-9999]]
                </code></td>
            <td>
                <?php echo rand(0, 100); ?><br>
                <?php echo rand(1000, 9999); ?>
            </td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_RANDOM'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>
                    [[random:this,that]]<br>
                    [[random:1-10,20,50,100]]
                </code></td>
            <td>
                <?php
                $values = ['this', 'that'];
                echo $values[rand(0, count($values) - 1)];
                ?>
                <br>

                <?php
                $values = [rand(1, 10), 20, 50, 100];
                echo $values[rand(0, count($values) - 1)];
                ?>
            </td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_RANDOM_LIST'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[text:MY_STRING]]</code></td>
            <td><?php echo JText::_('RL_MY_STRING'); ?></td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_TEXT'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[counter]]</code></td>
            <td>1</td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_COUNTER'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[escape]]
                    <wbr>
                    \1
                    <wbr>
                    [[/escape]]</code></td>
            <td><?php echo addslashes(html_entity_decode(JText::_('RL_DYNAMIC_TAG_STRING_EXAMPLE'))); ?></td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_ESCAPE'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[uppercase]]
                    <wbr>
                    \1
                    <wbr>
                    [[/uppercase]]</code></td>
            <td><?php echo strtoupper(JText::_('RL_DYNAMIC_TAG_STRING_EXAMPLE')); ?></td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_UPPERCASE'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[lowercase]]
                    <wbr>
                    \1
                    <wbr>
                    [[/lowercase]]</code></td>
            <td><?php echo strtolower(JText::_('RL_DYNAMIC_TAG_STRING_EXAMPLE')); ?></td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_LOWERCASE'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[notags]]
                    <wbr>
                    \1
                    <wbr>
                    [[/notags]]</code></td>
            <td><?php echo strip_tags(JText::_('RL_DYNAMIC_TAG_STRING_EXAMPLE')); ?></td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_NOTAGS'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[nowhitespace]]
                    <wbr>
                    \1
                    <wbr>
                    [[/nowhitespace]]</code></td>
            <td><?php echo str_replace(' ', '', strip_tags(JText::_('RL_DYNAMIC_TAG_STRING_EXAMPLE'))); ?></td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_NOWHITESPACE'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[toalias]]
                    <wbr>
                    \1
                    <wbr>
                    [[/toalias]]</code></td>
            <td><?php echo RL_Alias::get(JText::_('RL_DYNAMIC_TAG_STRING_EXAMPLE')); ?></td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_TOALIAS'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
        <tr>
            <td><code>[[replace from="string" to="different world"]]
                    <wbr>
                    \1
                    <wbr>
                    [[/replace]]</code></td>
            <td><?php echo str_replace('string', 'different world', JText::_('RL_DYNAMIC_TAG_STRING_EXAMPLE')); ?></td>
            <td><?php echo JText::_('RL_DYNAMIC_TAG_REPLACE'); ?></td>
            <?php echo $no; ?>
            <?php echo $yes; ?>
        </tr>
    </tbody>
</table>
