<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper as JHtml;
use Joomla\CMS\Language\Text as JText;
use Joomla\CMS\Layout\LayoutHelper as JLayout;
use Joomla\CMS\Router\Route as JRoute;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Form\Field\MiniColorField;
use RegularLabs\Library\Language as RL_Language;

RL_Document::useScript('keepalive');
RL_Document::useScript('form.validate');
RL_Document::script('regularlabs.admin-form');
RL_Document::script('regularlabs.admin-form-descriptions');
RL_Language::load('com_conditions');
?>

<form action="<?php echo JRoute::_('index.php?option=com_rereplacer&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" aria-label="<?php echo JText::_('COM_REREPLACER_FORM_' . ((int) $this->item->id === 0 ? 'NEW' : 'EDIT'), true); ?>" class="form-validate">
    <?php echo JLayout::render('joomla.edit.title_alias', $this); ?>

    <fieldset class="mt-3">
        <?php echo JHtml::_('uitab.startTabSet', 'main', ['active' => 'details']); ?>

        <?php echo JHtml::_('uitab.addTab', 'main', 'details', JText::_('JDETAILS')); ?>
        <div class="row form-vertical">
            <div class="col-xl-6">
                <?php echo $this->form->renderFieldset('search'); ?>
                <?php echo $this->form->renderFieldset('replace'); ?>
                <?php echo $this->form->renderFieldset('xml'); ?>
            </div>
            <div class="col-lg-6 col-xl-3">
                <?php echo $this->form->renderFieldset('options'); ?>
            </div>
            <div class="col-lg-6 col-xl-3">
                <?php echo $this->form->renderFieldset('details'); ?>
                <?php if ($this->config->use_categories) : ?>
                    <?php echo $this->form->renderFieldset('category'); ?>
                <?php endif; ?>
                <?php if ($this->config->use_colors) : ?>
                    <div class="control-group">
                        <div class="control-label">
                            <label id="jform_extra_color-lbl" for="jform_extra_color" role="button" tabindex="0">
                                <?php echo JText::_('RL_COLOR'); ?>
                            </label>
                        </div>

                        <div class="controls">
                            <?php
                            $colorfield = new MiniColorField;

                            $color = $this->item->color ?? '';

                            $element = new SimpleXMLElement(
                                '<field
                                                name="jform[color]"
                                                type="MiniColor"
                                                default=""
                                                colors="' . ($this->config->main_colors ?? '') . '"
                                                table="rereplacer"
                                                item_id="' . $this->item->id . '"
                                                />'
                            );

                            $element->value = $color;

                            $colorfield->setup($element, $color);

                            echo $colorfield->__get('input');
                            ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php echo JHtml::_('uitab.endTab'); ?>

        <?php echo JHtml::_('uitab.addTab', 'main', 'areas', JText::_('RR_SEARCH_AREAS')); ?>
        <div class="row form-vertical">
            <div class="col-lg-6">
                <?php echo $this->form->renderFieldset('areas_1'); ?>
            </div>
            <div class="col-lg-6">
                <?php echo $this->form->renderFieldset('areas_2'); ?>
            </div>
        </div>
        <?php echo JHtml::_('uitab.endTab'); ?>

        <?php echo JHtml::_('uitab.addTab', 'main', 'conditions', JText::_('RL_CONDITIONS')); ?>
        <div class="row form-vertical">
            <div class="col-lg-6">
                <?php echo $this->form->renderFieldset('conditions'); ?>
            </div>
            <div class="col-lg-6">
                <?php echo $this->form->renderFieldset('other_replace'); ?>
            </div>
        </div>
        <?php echo JHtml::_('uitab.endTab'); ?>

        <?php echo JHtml::_('uitab.endTabSet'); ?>

        <input type="hidden" name="task" value="">
        <?php echo JHtml::_('form.token'); ?>
    </fieldset>
</form>
