<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\Conditions\Administrator\Condition\Content;

defined('_JEXEC') or die;

use Joomla\Component\Content\Site\Model\ArticleModel as JArticleModel;
use RegularLabs\Component\Conditions\Administrator\Condition\Condition;
use RegularLabs\Component\Conditions\Administrator\Condition\Traits\isContent;

abstract class Content extends Condition
{
    public function getArticle()
    {
        if ($this->article)
        {
            return $this->article;
        }

        $model = new JArticleModel;

        $this->article = $model->getItem($this->request->id);

        return $this->article;
    }

    protected function isArticle()
    {
        if (empty($this->request->id))
        {
            return false;
        }

        return ($this->request->option == 'com_content' && $this->request->view == 'article')
            || ($this->request->option == 'com_flexicontent' && $this->request->view == 'item');
    }
}
