<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\Conditions\Administrator\Condition\Geo;

defined('_JEXEC') or die;

class PostalCode extends Geo
{
    public function pass()
    {
        if ( ! $this->getGeo() || empty($this->geo->postalCode))
        {
            return false;
        }

        // replace dashes with dots: 730-0011 => 730.0011
        $postalcode = str_replace('-', '.', $this->geo->postalCode);

        return $this->passInRange($postalcode);
    }
}
