<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\Conditions\Administrator\Condition\Geo;

use RegularLabs\Component\Conditions\Administrator\Condition\HasArraySelection;

defined('_JEXEC') or die;

class Region extends Geo
{
    use HasArraySelection;

    public function pass()
    {
        if ( ! $this->getGeo() || empty($this->geo->countryCode) || empty($this->geo->regionCodes))
        {
            return false;
        }

        $country = $this->geo->countryCode;
        $regions = $this->geo->regionCodes;

        array_walk($regions, function (&$region, $key, $country) {

            $region = $this->getCountryRegionCode($region, $country);
        }, $country);

        return $this->passSimple($regions);
    }

    private function getCountryRegionCode(&$region, $country)
    {
        switch ($country . '-' . $region)
        {
            case 'MX-CMX':
                return 'MX-DIF';

            default:
                return $country . '-' . $region;
        }
    }
}
