<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\Conditions\Administrator\Condition\Other;

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use RegularLabs\Component\Conditions\Administrator\Condition\Condition;
use RegularLabs\Component\Conditions\Administrator\Condition\HasArraySelection;

/**
 * Class Component
 *
 * @package RegularLabs\Library\Condition
 */
class Component extends Condition
{
    use HasArraySelection;

    public function pass()
    {
        $option = JFactory::getApplication()->input->get('option', '') == 'com_categories'
            ? 'com_categories'
            : $this->request->option;

        $options = [
            strtolower($option),
            strtolower(str_replace('com_', '', $option)),
        ];

        return $this->passSimple($options);
    }
}
