<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\Conditions\Administrator\Condition\Other;

defined('_JEXEC') or die;

use RegularLabs\Component\Conditions\Administrator\Condition\Condition;
use RegularLabs\Component\Conditions\Administrator\Condition\HasArraySelection;

class Tag extends Condition
{
    use HasArraySelection;

    public function pass()
    {
        if ( ! $this->request->id)
        {
            return false;
        }

        if (in_array($this->request->option, ['com_content', 'com_flexicontent']))
        {
            return $this->passTagsContent();
        }

        if (
            $this->request->option != 'com_tags'
            || $this->request->view != 'tag'
        )
        {
            return false;
        }

        return $this->passTag($this->request->id);
    }

    private function getTagsParentIds($id = 0)
    {
        $parentids = $this->getParentIds($id, 'tags');
        // Remove the root tag
        $parentids = array_diff($parentids, [1]);

        return $parentids;
    }

    private function passTag($tag)
    {
        $pass = in_array($tag, $this->selection);

        if ($pass)
        {
            // If passed, return false if assigned to only children
            // Else return true
            return (int) $this->params->include_children !== 2;
        }

        if ( ! $this->params->include_children)
        {
            return false;
        }

        // Return true if a parent id is present in the selection
        return array_intersect(
            $this->getTagsParentIds($tag),
            $this->selection
        );
    }

    private function passTagList($tags)
    {
        if ($this->params->match_all ?? false)
        {
            return $this->passTagListMatchAll($tags);
        }

        foreach ($tags as $tag)
        {
            if ( ! $this->passTag($tag->id) && ! $this->passTag($tag->title))
            {
                continue;
            }

            return true;
        }

        return false;
    }

    private function passTagListMatchAll($tags)
    {
        foreach ($this->selection as $id)
        {
            if ( ! $this->passTagMatchAll($id, $tags))
            {
                return false;
            }
        }

        return true;
    }

    private function passTagMatchAll($id, $tags)
    {

        foreach ($tags as $tag)
        {
            if ($tag->id == $id || $tag->title == $id)
            {
                return true;
            }
        }

        return false;
    }

    private function passTagsContent()
    {
        $is_item     = in_array($this->request->view, ['', 'article', 'item']);
        $is_category = in_array($this->request->view, ['category']);

        switch (true)
        {
            case ($is_item):
                $prefix = 'com_content.article';
                break;

            case ($is_category):
                $prefix = 'com_content.category';
                break;

            default:
                return false;
        }

        // Load the tags.
        $query = $this->db->getQuery(true)
            ->select($this->db->quoteName('t.id'))
            ->select($this->db->quoteName('t.title'))
            ->from('#__tags AS t')
            ->join(
                'INNER', '#__contentitem_tag_map AS m'
                . ' ON m.tag_id = t.id'
                . ' AND m.type_alias = ' . $this->db->quote($prefix)
                . ' AND m.content_item_id = ' . (int) $this->request->id
            );
        $this->db->setQuery($query);
        $tags = $this->db->loadObjectList();

        if (empty($tags))
        {
            return false;
        }

        return $this->passTagList($tags);
    }
}
