<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\Conditions\Administrator\Condition\Visitor;

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use RegularLabs\Component\Conditions\Administrator\Condition\Condition;
use RegularLabs\Component\Conditions\Administrator\Condition\HasArraySelection;
use RegularLabs\Library\DB as RL_DB;

class AccessLevel extends Condition
{
    use HasArraySelection;

    public function pass()
    {
        $user = JFactory::getApplication()->getIdentity() ?: JFactory::getUser();

        $levels = $user->getAuthorisedViewLevels();

        $this->selection = $this->convertAccessLevelNamesToIds($this->selection);

        if ($this->params->match_all ?? false)
        {
            return $this->passMatchAll($levels);
        }

        return $this->passSimple($levels);
    }

    private function convertAccessLevelNamesToIds($selection)
    {
        $names = [];

        foreach ($selection as $i => $level)
        {
            if (is_numeric($level))
            {
                continue;
            }

            unset($selection[$i]);

            $names[] = strtolower(str_replace(' ', '', $level));
        }

        if (empty($names))
        {
            return $selection;
        }

        $db = RL_DB::get();

        $query = $db->getQuery(true)
            ->select($db->quoteName('id'))
            ->from('#__viewlevels')
            ->where(RL_DB::in('LOWER(REPLACE(' . $db->quoteName('title') . ', " ", ""))', $names));
        $db->setQuery($query);

        $level_ids = $db->loadColumn();

        return array_unique(array_merge($selection, $level_ids));
    }

    private function passMatchAll($groups)
    {
        return ! array_diff($this->selection, $groups) && ! array_diff($groups, $this->selection);
    }
}
