<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\Conditions\Administrator\Form\Field;

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\HTML\HTMLHelper as JHtml;
use Joomla\CMS\Language\Text as JText;
use RegularLabs\Library\ArrayHelper as RL_Array;
use RegularLabs\Library\DB as RL_DB;
use RegularLabs\Library\Form\Form as RL_Form;
use RegularLabs\Library\Form\FormField as RL_FormField;
use RegularLabs\Library\Language as RL_Language;

class ConditionSelectionField extends RL_FormField
{
    public bool $is_select_list = true;
    public bool $use_ajax       = true;

    function getNameById($value, $attributes)
    {
        return RL_Array::implode($this->getNamesByIds([$value], $attributes));
    }

    function getNamesByIds($values, $attributes)
    {
        $db    = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select('DISTINCT a.id, a.alias, a.name')
            ->from('#__conditions AS a')
            ->where('a.published = 1')
            ->where(RL_DB::is('a.id', $values))
            ->order('a.name');

        $db->setQuery($query);
        $fields = $db->loadObjectList();

        return RL_Form::getNamesWithExtras($fields);
    }

    function getOptions()
    {
        RL_Language::load('com_conditions');

        $current_id = 0;

        if (($this->parent_request->option ?? '') === 'com_conditions')
        {
            $current_id = ($this->parent_request->id ?? 0);
        }

        $db    = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select('DISTINCT a.id, a.alias, a.name')
            ->from('#__conditions AS a')
            ->where('a.published = 1')
            ->where('a.id != ' . $current_id)
            ->order('a.name');

        $db->setQuery($query);

        $conditions = $db->loadObjectList();

        $options = [];

        $options[] = JHtml::_('select.option', '', '- ' . JText::_('CON_SELECT_A_CONDITION') . ' -');

        foreach ($conditions as $condition)
        {
            $options[] = JHtml::_('select.option', $condition->id, $condition->name);
        }

        return $options;
    }
}
