<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Component\Conditions\Administrator\Helper;

use DateTimeZone;
use Joomla\CMS\Factory as JFactory;
use RegularLabs\Library\Date as RL_Date;

class Date
{
    static $dates = [];
    static $timezone;

    public static function get($date = '', $ignore_time_zone = false)
    {
        $date = RL_Date::fix($date);

        $id = 'date_' . $date . '_' . $ignore_time_zone;

        if (isset(self::$dates[$id]))
        {
            return self::$dates[$id];
        }

        self::$dates[$id] = JFactory::getDate($date);

        if ( ! $ignore_time_zone)
        {
            self::$dates[$id]->setTimeZone(self::getTimeZone());
        }

        return self::$dates[$id];
    }

    public static function getDayNumber($string)
    {
        if ( ! is_string($string))
        {
            return false;
        }

        if (is_numeric($string))
        {
            return $string;
        }

        $string = strip_tags($string);

        return (int) date('N', strtotime($string));
    }

    public static function getMonthNumber($string)
    {
        if ( ! is_string($string))
        {
            return false;
        }

        if (is_numeric($string))
        {
            return $string;
        }

        return (int) date('m', strtotime($string));
    }

    public static function getNow()
    {
        return self::getString();
    }

    public static function getString($date = '', $format = 'Y-m-d H:i:s', $ignore_time_zone = false)
    {
        $date = self::get($date, $ignore_time_zone);

        return $date->format($format, true);
    }

    public static function getTimeStamp($date = '', $ignore_time_zone = false)
    {
        return strtotime(self::getString($date, 'Y-m-d H:i:s', $ignore_time_zone));
    }

    public static function pass($params, $date = null)
    {
        $datetime = strtotime($date ?: self::getNow());

        $comparison = $params->comparison ?? 'between';

        if ($comparison == 'before')
        {
            return $datetime < self::getTimeStamp($params->date ?? '');
        }

        if ($comparison == 'after')
        {
            return $datetime > self::getTimeStamp($params->date ?? '');
        }

        $from = $params->from ?? false;
        $to   = $params->to ?? false;

        // no date range set
        if ( ! $from && ! $to)
        {
            return true;
        }

        if (empty($params->recurring))
        {
            $from = $from ? self::getTimeStamp($from) : false;
            $to   = $to ? self::getTimeStamp($to) : false;

            return ( ! $from || $datetime >= $from)
                && ( ! $to || $datetime <= $to);
        }

        $from = strtotime(date('Y') . self::getString($from, '-m-d H:i:s'));
        $to   = strtotime(date('Y') . self::getString($to, '-m-d H:i:s'));

        // pass: from is before to
        if ($from <= $to)
        {
            // and now is between from and to
            return ($from < $datetime && $to > $datetime);
        }

        // pass: from is later in year than to and:
        // - to is after up
        // - or now is before from
        return ($to > $datetime || $from < $datetime);
    }

    private static function getTimeZone()
    {
        if ( ! is_null(self::$timezone))
        {
            return self::$timezone;
        }

        self::$timezone = new DateTimeZone(JFactory::getApplication()->getCfg('offset'));

        return self::$timezone;
    }
}
