<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use RegularLabs\Component\Conditions\Administrator\Helper\Summary;
use RegularLabs\Component\Conditions\Administrator\Model\ItemModel;

if (JFactory::getApplication()->isClient('site'))
{
    die();
}

echo (new Conditions)->render();
die;

class Conditions
{
    private $extension = '';
    private $message   = '';

    public function getCondition()
    {
        $input = JFactory::getApplication()->input;

        $id            = $input->getInt('id');
        $enabled_types = $input->getString('enabled_types');

        if ($id)
        {
            return (new ItemModel)->getConditionById($id, false, $enabled_types);
        }

        $extension = $input->get('extension', '');
        $item_id   = $input->getInt('item_id');

        if ($extension && $item_id)
        {
            return (new ItemModel)->getConditionByExtensionItem($extension, $item_id, false, $enabled_types);
        }

        $data = [];

        $form = $input->get('form', [], 'raw');

        foreach ($form as $key => $value)
        {
            $key        = str_replace('jform[', '', $key);
            $data[$key] = $value;
        }

        if (isset($data['extension']))
        {
            $this->extension = $data['extension'];
        }

        if (isset($data['message']))
        {
            $this->message = $data['message'];
        }

        if (isset($data['enabled_types']))
        {
            $enabled_types = $data['enabled_types'];
            unset($data['enabled_types']);
        }

        return (new ItemModel)->getConditionFromData($data, $enabled_types);
    }

    public function render()
    {
        $condition = $this->getCondition();

        $extension = $this->extension ?: JFactory::getApplication()->input->get('extension', '');
        $message   = $this->message ?: JFactory::getApplication()->input->get('message', '');

        if ($extension && $condition && $condition->published !== 1)
        {
            $condition = null;
        }

        return json_encode((object) [
            'has_conditions' => ! empty($condition),
            'id'             => $condition->id ?? '',
            'alias'          => $condition->alias ?? '',
            'name'           => $condition->name ?? '',
            'content'        => Summary::render($condition, $extension, $message),
        ]);
    }
}
