<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Language\Text as JText;
use Joomla\CMS\Router\Route as JRoute;

$input = JFactory::getApplication()->input;

$extension   = $input->get('extension', '');
$item_id     = $input->getInt('item_id');
$table       = $input->get('table', '');
$name_column = $input->get('name_column', '');

$current_item_name = $this->item->usage[$extension][$item_id]->item_name ?? null;

$url = 'index.php?option=com_conditions'
    . '&view=item'
    . '&id=' . $this->item->id
    . '&extension=' . $extension
    . '&item_id=' . $item_id
    . '&table=' . $table
    . '&name_column=' . $name_column
    . '&task=item.remove_mapping'
    . '&tmpl=component'
?>
<div class="text-center">
    <p><?php echo JText::_('CON_ONLY_ITEM_USING_CONDITION'); ?><br>
        <?php echo JText::_('CON_WHAT_TO_DO'); ?></p>
    <p>
        <a class="btn btn-primary" title="<?php echo JText::_('CON_BUTTON_REMOVE', true); ?>"
           href="<?php echo JRoute::_($url . '&remove=1'); ?>">
            <span class="icon-times" aria-hidden="true"></span>
            <?php echo JText::sprintf('CON_BUTTON_CONFIRM_REMOVE_BUT_KEEP', $current_item_name ? ': ' . $current_item_name : ''); ?>
        </a>
        <a class="btn btn-danger" title="<?php echo JText::_('CON_BUTTON_REMOVE', true); ?>"
           href="<?php echo JRoute::_($url . '&remove=all'); ?>"
           onclick="return confirm('<?php echo JText::_('RL_ARE_YOU_SURE', true); ?>')">
            <span class="icon-trash" aria-hidden="true"></span>
            <?php echo JText::_('CON_BUTTON_CONFIRM_REMOVE_COMPLETELY'); ?>
        </a>
    </p>
</div>
