<?php
/**
 * @package         Conditions
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use RegularLabs\Library\Document as RL_Document;

$input = JFactory::getApplication()->input;

$extension     = $input->get('extension', '');
$item_id       = $input->getInt('item_id');
$id            = $input->getInt('id');
$enabled_types = $input->getString('enabled_types');
$message       = $input->get('message', '');

$update = 'parent.RegularLabs.Conditions.updateSummaryByExtension("' . $extension . '", ' . $item_id . ', "' . $message . '", "' . $enabled_types . '");';

if ($id)
{
    $update = 'parent.RegularLabs.Conditions.updateSummaryByCondition(' . $id . ', "' . $extension . '", "' . $message . '", "' . $enabled_types . '");';
}

$script = '
    const modal = window.parent.Joomla.Modal && window.parent.Joomla.Modal.getCurrent();

    if (modal) {
        modal.addEventListener("shown.bs.modal", () => {
            setTimeout(()=>{modal.close();}, 500);
        });
        modal.addEventListener("hidden.bs.modal", () => {
            ' . $update . '
        });
        modal.close();
    } else {
        ' . $update . '
    }
';

RL_Document::scriptDeclaration($script, 'ConditionsModal', true, 'after');
?>
<div class="rl-spinner rl-spinner-lg"></div>
