<?php
/**
 * @package         Regular Labs Library
 * @version         23.9.3039
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Library\Form\Field;

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper as JHtml;
use RegularLabs\Library\Form\Form as RL_Form;
use RegularLabs\Library\Form\FormField as RL_FormField;
use RegularLabs\Library\RegEx as RL_RegEx;

class GeoField extends RL_FormField
{
    public      $attributes       = [
        'group' => 'countries',
    ];
    public      $continents       = [
        'AF' => 'Africa',
        'AS' => 'Asia',
        'EU' => 'Europe',
        'NA' => 'North America',
        'SA' => 'South America',
        'OC' => 'Oceania',
        'AN' => 'Antarctica',
    ];
    public      $countries        = [
        'AF' => "Afghanistan",
        'AX' => "Aland Islands",
        'AL' => "Albania",
        'DZ' => "Algeria",
        'AS' => "American Samoa",
        'AD' => "Andorra",
        'AO' => "Angola",
        'AI' => "Anguilla",
        'AQ' => "Antarctica",
        'AG' => "Antigua and Barbuda",
        'AR' => "Argentina",
        'AM' => "Armenia",
        'AW' => "Aruba",
        'AU' => "Australia",
        'AT' => "Austria",
        'AZ' => "Azerbaijan",
        'BS' => "Bahamas",
        'BH' => "Bahrain",
        'BD' => "Bangladesh",
        'BB' => "Barbados",
        'BY' => "Belarus",
        'BE' => "Belgium",
        'BZ' => "Belize",
        'BJ' => "Benin",
        'BM' => "Bermuda",
        'BT' => "Bhutan",
        'BO' => "Bolivia",
        'BA' => "Bosnia and Herzegovina",
        'BW' => "Botswana",
        'BV' => "Bouvet Island",
        'BR' => "Brazil",
        'IO' => "British Indian Ocean Territory",
        'BN' => "Brunei Darussalam",
        'BG' => "Bulgaria",
        'BF' => "Burkina Faso",
        'BI' => "Burundi",
        'KH' => "Cambodia",
        'CM' => "Cameroon",
        'CA' => "Canada",
        'CV' => "Cape Verde",
        'KY' => "Cayman Islands",
        'CF' => "Central African Republic",
        'TD' => "Chad",
        'CL' => "Chile",
        'CN' => "China",
        'CX' => "Christmas Island",
        'CC' => "Cocos (Keeling) Islands",
        'CO' => "Colombia",
        'KM' => "Comoros",
        'CG' => "Congo",
        'CD' => "Congo, The Democratic Republic of the",
        'CK' => "Cook Islands",
        'CR' => "Costa Rica",
        'CI' => "Cote d'Ivoire",
        'HR' => "Croatia",
        'CU' => "Cuba",
        'CY' => "Cyprus",
        'CZ' => "Czech Republic",
        'DK' => "Denmark",
        'DJ' => "Djibouti",
        'DM' => "Dominica",
        'DO' => "Dominican Republic",
        'EC' => "Ecuador",
        'EG' => "Egypt",
        'SV' => "El Salvador",
        'GQ' => "Equatorial Guinea",
        'ER' => "Eritrea",
        'EE' => "Estonia",
        'ET' => "Ethiopia",
        'FK' => "Falkland Islands (Malvinas)",
        'FO' => "Faroe Islands",
        'FJ' => "Fiji",
        'FI' => "Finland",
        'FR' => "France",
        'GF' => "French Guiana",
        'PF' => "French Polynesia",
        'TF' => "French Southern Territories",
        'GA' => "Gabon",
        'GM' => "Gambia",
        'GE' => "Georgia",
        'DE' => "Germany",
        'GH' => "Ghana",
        'GI' => "Gibraltar",
        'GR' => "Greece",
        'GL' => "Greenland",
        'GD' => "Grenada",
        'GP' => "Guadeloupe",
        'GU' => "Guam",
        'GT' => "Guatemala",
        'GG' => "Guernsey",
        'GN' => "Guinea",
        'GW' => "Guinea-Bissau",
        'GY' => "Guyana",
        'HT' => "Haiti",
        'HM' => "Heard Island and McDonald Islands",
        'VA' => "Holy See (Vatican City State)",
        'HN' => "Honduras",
        'HK' => "Hong Kong",
        'HU' => "Hungary",
        'IS' => "Iceland",
        'IN' => "India",
        'ID' => "Indonesia",
        'IR' => "Iran, Islamic Republic of",
        'IQ' => "Iraq",
        'IE' => "Ireland",
        'IM' => "Isle of Man",
        'IL' => "Israel",
        'IT' => "Italy",
        'JM' => "Jamaica",
        'JP' => "Japan",
        'JE' => "Jersey",
        'JO' => "Jordan",
        'KZ' => "Kazakhstan",
        'KE' => "Kenya",
        'KI' => "Kiribati",
        'KP' => "Korea, Democratic People's Republic of",
        'KR' => "Korea, Republic of",
        'KW' => "Kuwait",
        'KG' => "Kyrgyzstan",
        'LA' => "Lao People's Democratic Republic",
        'LV' => "Latvia",
        'LB' => "Lebanon",
        'LS' => "Lesotho",
        'LR' => "Liberia",
        'LY' => "Libyan Arab Jamahiriya",
        'LI' => "Liechtenstein",
        'LT' => "Lithuania",
        'LU' => "Luxembourg",
        'MO' => "Macao",
        'MK' => "Macedonia",
        'MG' => "Madagascar",
        'MW' => "Malawi",
        'MY' => "Malaysia",
        'MV' => "Maldives",
        'ML' => "Mali",
        'MT' => "Malta",
        'MH' => "Marshall Islands",
        'MQ' => "Martinique",
        'MR' => "Mauritania",
        'MU' => "Mauritius",
        'YT' => "Mayotte",
        'MX' => "Mexico",
        'FM' => "Micronesia, Federated States of",
        'MD' => "Moldova, Republic of",
        'MC' => "Monaco",
        'MN' => "Mongolia",
        'ME' => "Montenegro",
        'MS' => "Montserrat",
        'MA' => "Morocco",
        'MZ' => "Mozambique",
        'MM' => "Myanmar",
        'NA' => "Namibia",
        'NR' => "Nauru",
        'NP' => "Nepal",
        'NL' => "Netherlands",
        'AN' => "Netherlands Antilles",
        'NC' => "New Caledonia",
        'NZ' => "New Zealand",
        'NI' => "Nicaragua",
        'NE' => "Niger",
        'NG' => "Nigeria",
        'NU' => "Niue",
        'NF' => "Norfolk Island",
        'MP' => "Northern Mariana Islands",
        'NO' => "Norway",
        'OM' => "Oman",
        'PK' => "Pakistan",
        'PW' => "Palau",
        'PS' => "Palestinian Territory",
        'PA' => "Panama",
        'PG' => "Papua New Guinea",
        'PY' => "Paraguay",
        'PE' => "Peru",
        'PH' => "Philippines",
        'PN' => "Pitcairn",
        'PL' => "Poland",
        'PT' => "Portugal",
        'PR' => "Puerto Rico",
        'QA' => "Qatar",
        'RE' => "Reunion",
        'RO' => "Romania",
        'RU' => "Russian Federation",
        'RW' => "Rwanda",
        'SH' => "Saint Helena",
        'KN' => "Saint Kitts and Nevis",
        'LC' => "Saint Lucia",
        'PM' => "Saint Pierre and Miquelon",
        'VC' => "Saint Vincent and the Grenadines",
        'WS' => "Samoa",
        'SM' => "San Marino",
        'ST' => "Sao Tome and Principe",
        'SA' => "Saudi Arabia",
        'SN' => "Senegal",
        'RS' => "Serbia",
        'SC' => "Seychelles",
        'SL' => "Sierra Leone",
        'SG' => "Singapore",
        'SK' => "Slovakia",
        'SI' => "Slovenia",
        'SB' => "Solomon Islands",
        'SO' => "Somalia",
        'ZA' => "South Africa",
        'GS' => "South Georgia and the South Sandwich Islands",
        'ES' => "Spain",
        'LK' => "Sri Lanka",
        'SD' => "Sudan",
        'SR' => "Suriname",
        'SJ' => "Svalbard and Jan Mayen",
        'SZ' => "Swaziland",
        'SE' => "Sweden",
        'CH' => "Switzerland",
        'SY' => "Syrian Arab Republic",
        'TW' => "Taiwan",
        'TJ' => "Tajikistan",
        'TZ' => "Tanzania, United Republic of",
        'TH' => "Thailand",
        'TL' => "Timor-Leste",
        'TG' => "Togo",
        'TK' => "Tokelau",
        'TO' => "Tonga",
        'TT' => "Trinidad and Tobago",
        'TN' => "Tunisia",
        'TR' => "Turkey",
        'TM' => "Turkmenistan",
        'TC' => "Turks and Caicos Islands",
        'TV' => "Tuvalu",
        'UG' => "Uganda",
        'UA' => "Ukraine",
        'AE' => "United Arab Emirates",
        'GB' => "United Kingdom",
        'US' => "United States",
        'UM' => "United States Minor Outlying Islands",
        'UY' => "Uruguay",
        'UZ' => "Uzbekistan",
        'VU' => "Vanuatu",
        'VE' => "Venezuela",
        'VN' => "Vietnam",
        'VG' => "Virgin Islands, British",
        'VI' => "Virgin Islands, U.S.",
        'WF' => "Wallis and Futuna",
        'EH' => "Western Sahara",
        'YE' => "Yemen",
        'ZM' => "Zambia",
        'ZW' => "Zimbabwe",
    ];
    public bool $is_select_list   = true;
    public      $region_countries = [
        'AU' => "Australia",
        'BE' => "Belgium",
        'BR' => "Brazil",
        'BG' => "Bulgaria",
        'CA' => "Canada",
        'CN' => "China",
        'CY' => "Cyprus",
        'CZ' => "Czech Republic",
        'DK' => "Denmark",
        'EG' => "Egypt",
        'FR' => "France",
        'DE' => "Germany",
        'GR' => "Greece",
        'HK' => "Hong Kong",
        'HU' => "Hungary",
        'IS' => "Iceland",
        'IN' => "India",
        'ID' => "Indonesia",
        'IE' => "Ireland",
        'IL' => "Israel",
        'IT' => "Italy",
        'JP' => "Japan",
        'MX' => "Mexico",
        'MA' => "Morocco",
        'NL' => "Netherlands",
        'NG' => "Nigeria",
        'NO' => "Norway",
        'PH' => "Philippines",
        'PL' => "Poland",
        'PT' => "Portugal",
        'RO' => "Romania",
        'RU' => "Russian Federation",
        'SK' => "Slovakia",
        'SI' => "Slovenia",
        'ZA' => "South Africa",
        'ES' => "Spain",
        'SE' => "Sweden",
        'CH' => "Switzerland",
        'TW' => "Taiwan",
        'TH' => "Thailand",
        'TR' => "Turkey",
        'UA' => "Ukraine",
        'AE' => "United Arab Emirates",
        'GB' => "United Kingdom",
        'US' => "United States",
        'VN' => "Vietnam",
    ];
    public      $regions          = [
        "Australia"            => [
            'AU-ACT' => "Australian Capital Territory",
            'AU-NSW' => "New South Wales",
            'AU-NT'  => "Northern Territory",
            'AU-QLD' => "Queensland",
            'AU-SA'  => "South Australia",
            'AU-TAS' => "Tasmania",
            'AU-VIC' => "Victoria",
            'AU-WA'  => "Western Australia",
        ],
        "Belgium"              => [
            'BE-VAN' => "Antwerpen",
            'BE-WBR' => "Brabant Wallon",
            'BE-BRU' => "Brussels-Capital Region",
            'BE-WHT' => "Hainaut",
            'BE-WLG' => "Liege",
            'BE-VLI' => "Limburg",
            'BE-WLX' => "Luxembourg, Luxemburg",
            'BE-WNA' => "Namur",
            'BE-VOV' => "Oost-Vlaanderen",
            'BE-VBR' => "Vlaams-Brabant",
            'BE-VWV' => "West-Vlaanderen",
        ],
        "Brazil"               => [
            'BR-AC' => "Acre",
            'BR-AL' => "Alagoas",
            'BR-AP' => "Amapá",
            'BR-AM' => "Amazonas",
            'BR-BA' => "Bahia",
            'BR-CE' => "Ceará",
            'BR-DF' => "Distrito Federal",
            'BR-ES' => "Espírito Santo",
            'BR-FN' => "Fernando de Noronha",
            'BR-GO' => "Goiás",
            'BR-MA' => "Maranhão",
            'BR-MT' => "Mato Grosso",
            'BR-MS' => "Mato Grosso do Sul",
            'BR-MG' => "Minas Gerais",
            'BR-PR' => "Paraná",
            'BR-PB' => "Paraíba",
            'BR-PA' => "Pará",
            'BR-PE' => "Pernambuco",
            'BR-PI' => "Piauí",
            'BR-RN' => "Rio Grande do Norte",
            'BR-RS' => "Rio Grande do Sul",
            'BR-RJ' => "Rio de Janeiro",
            'BR-RO' => "Rondônia",
            'BR-RR' => "Roraima",
            'BR-SC' => "Santa Catarina",
            'BR-SE' => "Sergipe",
            'BR-SP' => "São Paulo",
            'BR-TO' => "Tocantins",
        ],
        "Bulgaria"             => [
            'BG-01' => "Blagoevgrad",
            'BG-02' => "Burgas",
            'BG-08' => "Dobrich",
            'BG-07' => "Gabrovo",
            'BG-26' => "Haskovo",
            'BG-09' => "Kardzhali",
            'BG-10' => "Kyustendil",
            'BG-11' => "Lovech",
            'BG-12' => "Montana",
            'BG-13' => "Pazardzhik",
            'BG-14' => "Pernik",
            'BG-15' => "Pleven",
            'BG-16' => "Plovdiv",
            'BG-17' => "Razgrad",
            'BG-18' => "Ruse",
            'BG-27' => "Shumen",
            'BG-19' => "Silistra",
            'BG-20' => "Sliven",
            'BG-21' => "Smolyan",
            'BG-23' => "Sofia",
            'BG-22' => "Sofia-Grad",
            'BG-24' => "Stara Zagora",
            'BG-25' => "Targovishte",
            'BG-03' => "Varna",
            'BG-04' => "Veliko Tarnovo",
            'BG-05' => "Vidin",
            'BG-06' => "Vratsa",
            'BG-28' => "Yambol",
        ],
        "Canada"               => [
            'CA-AB' => "Alberta",
            'CA-BC' => "British Columbia",
            'CA-MB' => "Manitoba",
            'CA-NB' => "New Brunswick",
            'CA-NL' => "Newfoundland and Labrador",
            'CA-NT' => "Northwest Territories",
            'CA-NS' => "Nova Scotia",
            'CA-NU' => "Nunavut",
            'CA-ON' => "Ontario",
            'CA-PE' => "Prince Edward Island",
            'CA-QC' => "Quebec",
            'CA-SK' => "Saskatchewan",
            'CA-YT' => "Yukon Territory",
        ],
        "China"                => [
            'CN-34' => "Anhui",
            'CN-92' => "Aomen (Macau)",
            'CN-11' => "Beijing",
            'CN-50' => "Chongqing",
            'CN-35' => "Fujian",
            'CN-62' => "Gansu",
            'CN-44' => "Guangdong",
            'CN-45' => "Guangxi",
            'CN-52' => "Guizhou",
            'CN-46' => "Hainan",
            'CN-13' => "Hebei",
            'CN-23' => "Heilongjiang",
            'CN-41' => "Henan",
            'CN-42' => "Hubei",
            'CN-43' => "Hunan",
            'CN-32' => "Jiangsu",
            'CN-36' => "Jiangxi",
            'CN-22' => "Jilin",
            'CN-21' => "Liaoning",
            'CN-15' => "Nei Mongol",
            'CN-64' => "Ningxia",
            'CN-63' => "Qinghai",
            'CN-61' => "Shaanxi",
            'CN-37' => "Shandong",
            'CN-31' => "Shanghai",
            'CN-14' => "Shanxi",
            'CN-51' => "Sichuan",
            'CN-71' => "Taiwan",
            'CN-12' => "Tianjin",
            'CN-91' => "Xianggang (Hong-Kong)",
            'CN-65' => "Xinjiang",
            'CN-54' => "Xizang",
            'CN-53' => "Yunnan",
            'CN-33' => "Zhejiang",
        ],
        "Cyprus"               => [
            'CY-04' => "Ammóchostos",
            'CY-06' => "Kerýneia",
            'CY-01' => "Lefkosía",
            'CY-02' => "Lemesós",
            'CY-03' => "Lárnaka",
            'CY-05' => "Páfos",
        ],
        "Czech Republic"       => [
            'CZ-201' => "Benešov",
            'CZ-202' => "Beroun",
            'CZ-621' => "Blansko",
            'CZ-622' => "Brno-město",
            'CZ-623' => "Brno-venkov",
            'CZ-801' => "Bruntál",
            'CZ-624' => "Břeclav",
            'CZ-411' => "Cheb",
            'CZ-422' => "Chomutov",
            'CZ-531' => "Chrudim",
            'CZ-321' => "Domažlice",
            'CZ-421' => "Děčín",
            'CZ-802' => "Frýdek Místek",
            'CZ-611' => "Havlíčkův Brod",
            'CZ-625' => "Hodonín",
            'CZ-521' => "Hradec Králové",
            'CZ-512' => "Jablonec nad Nisou",
            'CZ-711' => "Jeseník",
            'CZ-612' => "Jihlava",
            'CZ-JM'  => "Jihomoravský kraj",
            'CZ-JC'  => "Jihočeský kraj",
            'CZ-313' => "Jindřichův Hradec",
            'CZ-522' => "Jičín",
            'CZ-KA'  => "Karlovarský kraj",
            'CZ-412' => "Karlovy Vary",
            'CZ-803' => "Karviná",
            'CZ-203' => "Kladno",
            'CZ-322' => "Klatovy",
            'CZ-204' => "Kolín",
            'CZ-721' => "Kromĕříž",
            'CZ-KR'  => "Královéhradecký kraj",
            'CZ-205' => "Kutná Hora",
            'CZ-513' => "Liberec",
            'CZ-LI'  => "Liberecký kraj",
            'CZ-423' => "Litoměřice",
            'CZ-424' => "Louny",
            'CZ-207' => "Mladá Boleslav",
            'CZ-MO'  => "Moravskoslezský kraj",
            'CZ-425' => "Most",
            'CZ-206' => "Mělník",
            'CZ-804' => "Nový Jičín",
            'CZ-208' => "Nymburk",
            'CZ-523' => "Náchod",
            'CZ-712' => "Olomouc",
            'CZ-OL'  => "Olomoucký kraj",
            'CZ-805' => "Opava",
            'CZ-806' => "Ostrava město",
            'CZ-532' => "Pardubice",
            'CZ-PA'  => "Pardubický kraj",
            'CZ-613' => "Pelhřimov",
            'CZ-324' => "Plzeň jih",
            'CZ-323' => "Plzeň město",
            'CZ-325' => "Plzeň sever",
            'CZ-PL'  => "Plzeňský kraj",
            'CZ-315' => "Prachatice",
            'CZ-101' => "Praha 1",
            'CZ-10A' => "Praha 10",
            'CZ-10B' => "Praha 11",
            'CZ-10C' => "Praha 12",
            'CZ-10D' => "Praha 13",
            'CZ-10E' => "Praha 14",
            'CZ-10F' => "Praha 15",
            'CZ-102' => "Praha 2",
            'CZ-103' => "Praha 3",
            'CZ-104' => "Praha 4",
            'CZ-105' => "Praha 5",
            'CZ-106' => "Praha 6",
            'CZ-107' => "Praha 7",
            'CZ-108' => "Praha 8",
            'CZ-109' => "Praha 9",
            'CZ-209' => "Praha východ",
            'CZ-20A' => "Praha západ",
            'CZ-PR'  => "Praha, hlavní město",
            'CZ-713' => "Prostĕjov",
            'CZ-314' => "Písek",
            'CZ-714' => "Přerov",
            'CZ-20B' => "Příbram",
            'CZ-20C' => "Rakovník",
            'CZ-326' => "Rokycany",
            'CZ-524' => "Rychnov nad Kněžnou",
            'CZ-514' => "Semily",
            'CZ-413' => "Sokolov",
            'CZ-316' => "Strakonice",
            'CZ-ST'  => "Středočeský kraj",
            'CZ-533' => "Svitavy",
            'CZ-327' => "Tachov",
            'CZ-426' => "Teplice",
            'CZ-525' => "Trutnov",
            'CZ-317' => "Tábor",
            'CZ-614' => "Třebíč",
            'CZ-722' => "Uherské Hradištĕ",
            'CZ-723' => "Vsetín",
            'CZ-VY'  => "Vysočina",
            'CZ-626' => "Vyškov",
            'CZ-724' => "Zlín",
            'CZ-ZL'  => "Zlínský kraj",
            'CZ-627' => "Znojmo",
            'CZ-US'  => "Ústecký kraj",
            'CZ-427' => "Ústí nad Labem",
            'CZ-534' => "Ústí nad Orlicí",
            'CZ-511' => "Česká Lípa",
            'CZ-311' => "České Budějovice",
            'CZ-312' => "Český Krumlov",
            'CZ-715' => "Šumperk",
            'CZ-615' => "Žd’ár nad Sázavou",
        ],
        "Denmark"              => [
            'DK-84' => "Hovedstaden",
            'DK-82' => "Midtjylland",
            'DK-81' => "Nordjylland",
            'DK-85' => "Sjælland",
            'DK-83' => "Syddanmark",
        ],
        "Egypt"                => [
            'EG-DK'  => "Ad Daqahlīyah",
            'EG-BA'  => "Al Bahr al Ahmar",
            'EG-BH'  => "Al Buhayrah",
            'EG-FYM' => "Al Fayyūm",
            'EG-GH'  => "Al Gharbīyah",
            'EG-ALX' => "Al Iskandarīyah",
            'EG-IS'  => "Al Ismā`īlīyah",
            'EG-GZ'  => "Al Jīzah",
            'EG-MN'  => "Al Minyā",
            'EG-MNF' => "Al Minūfīyah",
            'EG-KB'  => "Al Qalyūbīyah",
            'EG-C'   => "Al Qāhirah",
            'EG-WAD' => "Al Wādī al Jadīd",
            'EG-SUZ' => "As Suways",
            'EG-SU'  => "As Sādis min Uktūbar",
            'EG-SHR' => "Ash Sharqīyah",
            'EG-ASN' => "Aswān",
            'EG-AST' => "Asyūt",
            'EG-BNS' => "Banī Suwayf",
            'EG-PTS' => "Būr Sa`īd",
            'EG-DT'  => "Dumyāt",
            'EG-JS'  => "Janūb Sīnā'",
            'EG-KFS' => "Kafr ash Shaykh",
            'EG-MT'  => "Matrūh",
            'EG-KN'  => "Qinā",
            'EG-SIN' => "Shamal Sīnā'",
            'EG-SHG' => "Sūhāj",
            'EG-HU'  => "Ḩulwān",
        ],
        "France"               => [
            'FR-01' => "Ain",
            'FR-02' => "Aisne",
            'FR-03' => "Allier",
            'FR-06' => "Alpes-Maritimes",
            'FR-04' => "Alpes-de-Haute-Provence",
            'FR-A'  => "Alsace",
            'FR-B'  => "Aquitaine",
            'FR-08' => "Ardennes",
            'FR-07' => "Ardèche",
            'FR-09' => "Ariège",
            'FR-10' => "Aube",
            'FR-11' => "Aude",
            'FR-C'  => "Auvergne",
            'FR-12' => "Aveyron",
            'FR-67' => "Bas-Rhin",
            'FR-P'  => "Basse-Normandie",
            'FR-13' => "Bouches-du-Rhône",
            'FR-D'  => "Bourgogne",
            'FR-E'  => "Bretagne",
            'FR-14' => "Calvados",
            'FR-15' => "Cantal",
            'FR-F'  => "Centre",
            'FR-G'  => "Champagne-Ardenne",
            'FR-16' => "Charente",
            'FR-17' => "Charente-Maritime",
            'FR-18' => "Cher",
            'FR-CP' => "Clipperton",
            'FR-19' => "Corrèze",
            'FR-H'  => "Corse",
            'FR-2A' => "Corse-du-Sud",
            'FR-23' => "Creuse",
            'FR-21' => "Côte-d'Or",
            'FR-22' => "Côtes-d'Armor",
            'FR-79' => "Deux-Sèvres",
            'FR-24' => "Dordogne",
            'FR-25' => "Doubs",
            'FR-26' => "Drôme",
            'FR-91' => "Essonne",
            'FR-27' => "Eure",
            'FR-28' => "Eure-et-Loir",
            'FR-29' => "Finistère",
            'FR-I'  => "Franche-Comté",
            'FR-30' => "Gard",
            'FR-32' => "Gers",
            'FR-33' => "Gironde",
            'FR-GP' => "Guadeloupe",
            'FR-GF' => "Guyane",
            'FR-68' => "Haut-Rhin",
            'FR-2B' => "Haute-Corse",
            'FR-31' => "Haute-Garonne",
            'FR-43' => "Haute-Loire",
            'FR-52' => "Haute-Marne",
            'FR-Q'  => "Haute-Normandie",
            'FR-74' => "Haute-Savoie",
            'FR-70' => "Haute-Saône",
            'FR-87' => "Haute-Vienne",
            'FR-05' => "Hautes-Alpes",
            'FR-65' => "Hautes-Pyrénées",
            'FR-92' => "Hauts-de-Seine",
            'FR-34' => "Hérault",
            'FR-35' => "Ille-et-Vilaine",
            'FR-36' => "Indre",
            'FR-37' => "Indre-et-Loire",
            'FR-38' => "Isère",
            'FR-39' => "Jura",
            'FR-40' => "Landes",
            'FR-K'  => "Languedoc-Roussillon",
            'FR-L'  => "Limousin",
            'FR-41' => "Loir-et-Cher",
            'FR-42' => "Loire",
            'FR-44' => "Loire-Atlantique",
            'FR-45' => "Loiret",
            'FR-M'  => "Lorraine",
            'FR-46' => "Lot",
            'FR-47' => "Lot-et-Garonne",
            'FR-48' => "Lozère",
            'FR-49' => "Maine-et-Loire",
            'FR-50' => "Manche",
            'FR-51' => "Marne",
            'FR-MQ' => "Martinique",
            'FR-53' => "Mayenne",
            'FR-YT' => "Mayotte",
            'FR-54' => "Meurthe-et-Moselle",
            'FR-55' => "Meuse",
            'FR-N'  => "Midi-Pyrénées",
            'FR-56' => "Morbihan",
            'FR-57' => "Moselle",
            'FR-58' => "Nièvre",
            'FR-59' => "Nord",
            'FR-O'  => "Nord - Pas-de-Calais",
            'FR-NC' => "Nouvelle-Calédonie",
            'FR-60' => "Oise",
            'FR-61' => "Orne",
            'FR-75' => "Paris",
            'FR-62' => "Pas-de-Calais",
            'FR-R'  => "Pays de la Loire",
            'FR-S'  => "Picardie",
            'FR-T'  => "Poitou-Charentes",
            'FR-PF' => "Polynésie française",
            'FR-U'  => "Provence-Alpes-Côte d'Azur",
            'FR-63' => "Puy-de-Dôme",
            'FR-64' => "Pyrénées-Atlantiques",
            'FR-66' => "Pyrénées-Orientales",
            'FR-69' => "Rhône",
            'FR-V'  => "Rhône-Alpes",
            'FR-RE' => "Réunion",
            'FR-BL' => "Saint-Barthélemy",
            'FR-MF' => "Saint-Martin",
            'FR-PM' => "Saint-Pierre-et-Miquelon",
            'FR-72' => "Sarthe",
            'FR-73' => "Savoie",
            'FR-71' => "Saône-et-Loire",
            'FR-76' => "Seine-Maritime",
            'FR-93' => "Seine-Saint-Denis",
            'FR-77' => "Seine-et-Marne",
            'FR-80' => "Somme",
            'FR-81' => "Tarn",
            'FR-82' => "Tarn-et-Garonne",
            'FR-TF' => "Terres australes françaises",
            'FR-90' => "Territoire de Belfort",
            'FR-95' => "Val d'Oise",
            'FR-94' => "Val-de-Marne",
            'FR-83' => "Var",
            'FR-84' => "Vaucluse",
            'FR-85' => "Vendée",
            'FR-86' => "Vienne",
            'FR-88' => "Vosges",
            'FR-WF' => "Wallis-et-Futuna",
            'FR-89' => "Yonne",
            'FR-78' => "Yvelines",
            'FR-J'  => "Île-de-France",
        ],
        "Germany"              => [
            'DE-BW' => "Baden-Württemberg",
            'DE-BY' => "Bayern",
            'DE-BE' => "Berlin",
            'DE-BB' => "Brandenburg",
            'DE-HB' => "Bremen",
            'DE-HH' => "Hamburg",
            'DE-HE' => "Hessen",
            'DE-MV' => "Mecklenburg-Vorpommern",
            'DE-NI' => "Niedersachsen",
            'DE-NW' => "Nordrhein-Westfalen",
            'DE-RP' => "Rheinland-Pfalz",
            'DE-SL' => "Saarland",
            'DE-SN' => "Sachsen",
            'DE-ST' => "Sachsen-Anhalt",
            'DE-SH' => "Schleswig-Holstein",
            'DE-TH' => "Thüringen",
        ],
        "Greece"               => [
            'GR-13' => "Achaïa",
            'GR-69' => "Agio Oros",
            'GR-01' => "Aitolia kai Akarnania",
            'GR-A'  => "Anatoliki Makedonia kai Thraki",
            'GR-11' => "Argolida",
            'GR-12' => "Arkadia",
            'GR-31' => "Arta",
            'GR-A1' => "Attiki",
            'GR-64' => "Chalkidiki",
            'GR-94' => "Chania",
            'GR-85' => "Chios",
            'GR-81' => "Dodekanisos",
            'GR-52' => "Drama",
            'GR-G'  => "Dytiki Ellada",
            'GR-C'  => "Dytiki Makedonia",
            'GR-71' => "Evros",
            'GR-05' => "Evrytania",
            'GR-04' => "Evvoias",
            'GR-63' => "Florina",
            'GR-07' => "Fokida",
            'GR-06' => "Fthiotida",
            'GR-51' => "Grevena",
            'GR-14' => "Ileia",
            'GR-53' => "Imathia",
            'GR-33' => "Ioannina",
            'GR-F'  => "Ionia Nisia",
            'GR-D'  => "Ipeiros",
            'GR-91' => "Irakleio",
            'GR-41' => "Karditsa",
            'GR-56' => "Kastoria",
            'GR-55' => "Kavala",
            'GR-23' => "Kefallonia",
            'GR-B'  => "Kentriki Makedonia",
            'GR-22' => "Kerkyra",
            'GR-57' => "Kilkis",
            'GR-15' => "Korinthia",
            'GR-58' => "Kozani",
            'GR-M'  => "Kriti",
            'GR-82' => "Kyklades",
            'GR-16' => "Lakonia",
            'GR-42' => "Larisa",
            'GR-92' => "Lasithi",
            'GR-24' => "Lefkada",
            'GR-83' => "Lesvos",
            'GR-43' => "Magnisia",
            'GR-17' => "Messinia",
            'GR-L'  => "Notio Aigaio",
            'GR-59' => "Pella",
            'GR-J'  => "Peloponnisos",
            'GR-61' => "Pieria",
            'GR-34' => "Preveza",
            'GR-93' => "Rethymno",
            'GR-73' => "Rodopi",
            'GR-84' => "Samos",
            'GR-62' => "Serres",
            'GR-H'  => "Sterea Ellada",
            'GR-32' => "Thesprotia",
            'GR-E'  => "Thessalia",
            'GR-54' => "Thessaloniki",
            'GR-44' => "Trikala",
            'GR-03' => "Voiotia",
            'GR-K'  => "Voreio Aigaio",
            'GR-72' => "Xanthi",
            'GR-21' => "Zakynthos",
        ],
        "Hungary"              => [
            'HU-BA' => "Baranya",
            'HU-BZ' => "Borsod-Abaúj-Zemplén",
            'HU-BU' => "Budapest",
            'HU-BK' => "Bács-Kiskun",
            'HU-BE' => "Békés",
            'HU-BC' => "Békéscsaba",
            'HU-CS' => "Csongrád",
            'HU-DE' => "Debrecen",
            'HU-DU' => "Dunaújváros",
            'HU-EG' => "Eger",
            'HU-FE' => "Fejér",
            'HU-GY' => "Győr",
            'HU-GS' => "Győr-Moson-Sopron",
            'HU-HB' => "Hajdú-Bihar",
            'HU-HE' => "Heves",
            'HU-HV' => "Hódmezővásárhely",
            'HU-JN' => "Jász-Nagykun-Szolnok",
            'HU-KV' => "Kaposvár",
            'HU-KM' => "Kecskemét",
            'HU-KE' => "Komárom-Esztergom",
            'HU-MI' => "Miskolc",
            'HU-NK' => "Nagykanizsa",
            'HU-NY' => "Nyíregyháza",
            'HU-NO' => "Nógrád",
            'HU-PE' => "Pest",
            'HU-PS' => "Pécs",
            'HU-ST' => "Salgótarján",
            'HU-SO' => "Somogy",
            'HU-SN' => "Sopron",
            'HU-SZ' => "Szabolcs-Szatmár-Bereg",
            'HU-SD' => "Szeged",
            'HU-SS' => "Szekszárd",
            'HU-SK' => "Szolnok",
            'HU-SH' => "Szombathely",
            'HU-SF' => "Székesfehérvár",
            'HU-TB' => "Tatabánya",
            'HU-TO' => "Tolna",
            'HU-VA' => "Vas",
            'HU-VM' => "Veszprém",
            'HU-VE' => "Veszprém (county)",
            'HU-ZA' => "Zala",
            'HU-ZE' => "Zalaegerszeg",
            'HU-ER' => "Érd",
        ],
        "Iceland"              => [
            'IS-7' => "Austurland",
            'IS-1' => "Höfuðborgarsvæðið",
            'IS-6' => "Norðurland eystra",
            'IS-5' => "Norðurland vestra",
            'IS-0' => "Reykjavík",
            'IS-8' => "Suðurland",
            'IS-2' => "Suðurnes",
            'IS-4' => "Vestfirðir",
            'IS-3' => "Vesturland",
        ],
        "India"                => [
            'IN-AN' => "Andaman and Nicobar Islands",
            'IN-AP' => "Andhra Pradesh",
            'IN-AR' => "Arunāchal Pradesh",
            'IN-AS' => "Assam",
            'IN-BR' => "Bihār",
            'IN-CH' => "Chandīgarh",
            'IN-CT' => "Chhattīsgarh",
            'IN-DD' => "Damān and Diu",
            'IN-DL' => "Delhi",
            'IN-DN' => "Dādra and Nagar Haveli",
            'IN-GA' => "Goa",
            'IN-GJ' => "Gujarāt",
            'IN-HR' => "Haryāna",
            'IN-HP' => "Himāchal Pradesh",
            'IN-JK' => "Jammu and Kashmīr",
            'IN-JH' => "Jharkhand",
            'IN-KA' => "Karnātaka",
            'IN-KL' => "Kerala",
            'IN-LD' => "Lakshadweep",
            'IN-MP' => "Madhya Pradesh",
            'IN-MH' => "Mahārāshtra",
            'IN-MN' => "Manipur",
            'IN-ML' => "Meghālaya",
            'IN-MZ' => "Mizoram",
            'IN-NL' => "Nāgāland",
            'IN-OR' => "Orissa",
            'IN-PY' => "Pondicherry",
            'IN-PB' => "Punjab",
            'IN-RJ' => "Rājasthān",
            'IN-SK' => "Sikkim",
            'IN-TN' => "Tamil Nādu",
            'IN-TR' => "Tripura",
            'IN-UP' => "Uttar Pradesh",
            'IN-UL' => "Uttaranchal",
            'IN-WB' => "West Bengal",
        ],
        "Indonesia"            => [
            'ID-AC' => "Aceh",
            'ID-BA' => "Bali",
            'ID-BB' => "Bangka Belitung",
            'ID-BT' => "Banten",
            'ID-BE' => "Bengkulu",
            'ID-GO' => "Gorontalo",
            'ID-JK' => "Jakarta Raya",
            'ID-JA' => "Jambi",
            'ID-JW' => "Jawa",
            'ID-JB' => "Jawa Barat",
            'ID-JT' => "Jawa Tengah",
            'ID-JI' => "Jawa Timur",
            'ID-KA' => "Kalimantan",
            'ID-KB' => "Kalimantan Barat",
            'ID-KS' => "Kalimantan Selatan",
            'ID-KT' => "Kalimantan Tengah",
            'ID-KI' => "Kalimantan Timur",
            'ID-KR' => "Kepulauan Riau",
            'ID-LA' => "Lampung",
            'ID-MA' => "Maluku",
            'ID-MU' => "Maluku Utara",
            'ID-NU' => "Nusa Tenggara",
            'ID-NB' => "Nusa Tenggara Barat",
            'ID-NT' => "Nusa Tenggara Timur",
            'ID-PA' => "Papua",
            'ID-PB' => "Papua Barat",
            'ID-RI' => "Riau",
            'ID-SL' => "Sulawesi",
            'ID-SR' => "Sulawesi Barat",
            'ID-SN' => "Sulawesi Selatan",
            'ID-ST' => "Sulawesi Tengah",
            'ID-SG' => "Sulawesi Tenggara",
            'ID-SA' => "Sulawesi Utara",
            'ID-SM' => "Sumatera",
            'ID-SU' => "Sumatera Utara",
            'ID-SB' => "Sumatra Barat",
            'ID-SS' => "Sumatra Selatan",
            'ID-YO' => "Yogyakarta",
        ],
        "Ireland"              => [
            'IE-CW' => "Carlow",
            'IE-CN' => "Cavan",
            'IE-CE' => "Clare",
            'IE-C'  => "Connacht",
            'IE-CO' => "Cork",
            'IE-DL' => "Donegal",
            'IE-D'  => "Dublin",
            'IE-G'  => "Galway",
            'IE-KY' => "Kerry",
            'IE-KE' => "Kildare",
            'IE-KK' => "Kilkenny",
            'IE-LS' => "Laois",
            'IE-L'  => "Leinster",
            'IE-LM' => "Leitrim",
            'IE-LK' => "Limerick",
            'IE-LD' => "Longford",
            'IE-LH' => "Louth",
            'IE-MO' => "Mayo",
            'IE-MH' => "Meath",
            'IE-MN' => "Monaghan",
            'IE-M'  => "Munster",
            'IE-OY' => "Offaly",
            'IE-RN' => "Roscommon",
            'IE-SO' => "Sligo",
            'IE-TA' => "Tipperary",
            'IE-U'  => "Ulster",
            'IE-WD' => "Waterford",
            'IE-WH' => "Westmeath",
            'IE-WX' => "Wexford",
            'IE-WW' => "Wicklow",
        ],
        "Israel"               => [
            'IL-D'  => "HaDarom",
            'IL-M'  => "HaMerkaz",
            'IL-Z'  => "HaZafon",
            'IL-HA' => "Hefa",
            'IL-TA' => "Tel-Aviv",
            'IL-JM' => "Yerushalayim Al Quds",
        ],
        "Italy"                => [
            'IT-65' => "Abruzzo",
            'IT-AG' => "Agrigento",
            'IT-AL' => "Alessandria",
            'IT-AN' => "Ancona",
            'IT-AO' => "Aosta",
            'IT-AR' => "Arezzo",
            'IT-AP' => "Ascoli Piceno",
            'IT-AT' => "Asti",
            'IT-AV' => "Avellino",
            'IT-BA' => "Bari",
            'IT-BT' => "Barletta-Andria-Trani",
            'IT-77' => "Basilicata",
            'IT-BL' => "Belluno",
            'IT-BN' => "Benevento",
            'IT-BG' => "Bergamo",
            'IT-BI' => "Biella",
            'IT-BO' => "Bologna",
            'IT-BZ' => "Bolzano",
            'IT-BS' => "Brescia",
            'IT-BR' => "Brindisi",
            'IT-CA' => "Cagliari",
            'IT-78' => "Calabria",
            'IT-CL' => "Caltanissetta",
            'IT-72' => "Campania",
            'IT-CB' => "Campobasso",
            'IT-CI' => "Carbonia-Iglesias",
            'IT-CE' => "Caserta",
            'IT-CT' => "Catania",
            'IT-CZ' => "Catanzaro",
            'IT-CH' => "Chieti",
            'IT-CO' => "Como",
            'IT-CS' => "Cosenza",
            'IT-CR' => "Cremona",
            'IT-KR' => "Crotone",
            'IT-CN' => "Cuneo",
            'IT-45' => "Emilia-Romagna",
            'IT-EN' => "Enna",
            'IT-FM' => "Fermo",
            'IT-FE' => "Ferrara",
            'IT-FI' => "Firenze",
            'IT-FG' => "Foggia",
            'IT-FC' => "Forlì-Cesena",
            'IT-36' => "Friuli-Venezia Giulia",
            'IT-FR' => "Frosinone",
            'IT-GE' => "Genova",
            'IT-GO' => "Gorizia",
            'IT-GR' => "Grosseto",
            'IT-IM' => "Imperia",
            'IT-IS' => "Isernia",
            'IT-AQ' => "L'Aquila",
            'IT-SP' => "La Spezia",
            'IT-LT' => "Latina",
            'IT-62' => "Lazio",
            'IT-LE' => "Lecce",
            'IT-LC' => "Lecco",
            'IT-42' => "Liguria",
            'IT-LI' => "Livorno",
            'IT-LO' => "Lodi",
            'IT-25' => "Lombardia",
            'IT-LU' => "Lucca",
            'IT-MC' => "Macerata",
            'IT-MN' => "Mantova",
            'IT-57' => "Marche",
            'IT-MS' => "Massa-Carrara",
            'IT-MT' => "Matera",
            'IT-VS' => "Medio Campidano",
            'IT-ME' => "Messina",
            'IT-MI' => "Milano",
            'IT-MO' => "Modena",
            'IT-67' => "Molise",
            'IT-MB' => "Monza e Brianza",
            'IT-NA' => "Napoli",
            'IT-NO' => "Novara",
            'IT-NU' => "Nuoro",
            'IT-OG' => "Ogliastra",
            'IT-OT' => "Olbia-Tempio",
            'IT-OR' => "Oristano",
            'IT-PD' => "Padova",
            'IT-PA' => "Palermo",
            'IT-PR' => "Parma",
            'IT-PV' => "Pavia",
            'IT-PG' => "Perugia",
            'IT-PU' => "Pesaro e Urbino",
            'IT-PE' => "Pescara",
            'IT-PC' => "Piacenza",
            'IT-21' => "Piemonte",
            'IT-PI' => "Pisa",
            'IT-PT' => "Pistoia",
            'IT-PN' => "Pordenone",
            'IT-PZ' => "Potenza",
            'IT-PO' => "Prato",
            'IT-75' => "Puglia",
            'IT-RG' => "Ragusa",
            'IT-RA' => "Ravenna",
            'IT-RC' => "Reggio Calabria",
            'IT-RE' => "Reggio Emilia",
            'IT-RI' => "Rieti",
            'IT-RN' => "Rimini",
            'IT-RM' => "Roma",
            'IT-RO' => "Rovigo",
            'IT-SA' => "Salerno",
            'IT-88' => "Sardegna",
            'IT-SS' => "Sassari",
            'IT-SV' => "Savona",
            'IT-82' => "Sicilia",
            'IT-SI' => "Siena",
            'IT-SR' => "Siracusa",
            'IT-SO' => "Sondrio",
            'IT-TA' => "Taranto",
            'IT-TE' => "Teramo",
            'IT-TR' => "Terni",
            'IT-TO' => "Torino",
            'IT-52' => "Toscana",
            'IT-TP' => "Trapani",
            'IT-32' => "Trentino-Alto Adige",
            'IT-TN' => "Trento",
            'IT-TV' => "Treviso",
            'IT-TS' => "Trieste",
            'IT-UD' => "Udine",
            'IT-55' => "Umbria",
            'IT-23' => "Valle d'Aosta",
            'IT-VA' => "Varese",
            'IT-34' => "Veneto",
            'IT-VE' => "Venezia",
            'IT-VB' => "Verbano-Cusio-Ossola",
            'IT-VC' => "Vercelli",
            'IT-VR' => "Verona",
            'IT-VV' => "Vibo Valentia",
            'IT-VI' => "Vicenza",
            'IT-VT' => "Viterbo",
        ],
        "Japan"                => [
            'JP-23' => "Aichi",
            'JP-05' => "Akita",
            'JP-02' => "Aomori",
            'JP-12' => "Chiba",
            'JP-38' => "Ehime",
            'JP-18' => "Fukui",
            'JP-40' => "Fukuoka",
            'JP-07' => "Fukushima",
            'JP-21' => "Gifu",
            'JP-10' => "Gunma",
            'JP-34' => "Hiroshima",
            'JP-01' => "Hokkaido",
            'JP-28' => "Hyogo",
            'JP-08' => "Ibaraki",
            'JP-17' => "Ishikawa",
            'JP-03' => "Iwate",
            'JP-37' => "Kagawa",
            'JP-46' => "Kagoshima",
            'JP-14' => "Kanagawa",
            'JP-39' => "Kochi",
            'JP-43' => "Kumamoto",
            'JP-26' => "Kyoto",
            'JP-24' => "Mie",
            'JP-04' => "Miyagi",
            'JP-45' => "Miyazaki",
            'JP-20' => "Nagano",
            'JP-42' => "Nagasaki",
            'JP-29' => "Nara",
            'JP-15' => "Niigata",
            'JP-44' => "Oita",
            'JP-33' => "Okayama",
            'JP-47' => "Okinawa",
            'JP-27' => "Osaka",
            'JP-41' => "Saga",
            'JP-11' => "Saitama",
            'JP-25' => "Shiga",
            'JP-32' => "Shimane",
            'JP-22' => "Shizuoka",
            'JP-09' => "Tochigi",
            'JP-36' => "Tokushima",
            'JP-13' => "Tokyo",
            'JP-31' => "Tottori",
            'JP-16' => "Toyama",
            'JP-30' => "Wakayama",
            'JP-06' => "Yamagata",
            'JP-35' => "Yamaguchi",
            'JP-19' => "Yamanashi",
        ],
        "Mexico"               => [
            'MX-AGU' => "Aguascalientes",
            'MX-BCN' => "Baja California",
            'MX-BCS' => "Baja California Sur",
            'MX-CAM' => "Campeche",
            'MX-CHP' => "Chiapas",
            'MX-CHH' => "Chihuahua",
            'MX-COA' => "Coahuila",
            'MX-COL' => "Colima",
            'MX-DIF' => "Distrito Federal (Mexico City)",
            'MX-DUR' => "Durango",
            'MX-GUA' => "Guanajuato",
            'MX-GRO' => "Guerrero",
            'MX-HID' => "Hidalgo",
            'MX-JAL' => "Jalisco",
            'MX-MIC' => "Michoacán",
            'MX-MOR' => "Morelos",
            'MX-MEX' => "México",
            'MX-NAY' => "Nayarit",
            'MX-NLE' => "Nuevo León",
            'MX-OAX' => "Oaxaca",
            'MX-PUE' => "Puebla",
            'MX-QUE' => "Querétaro",
            'MX-ROO' => "Quintana Roo",
            'MX-SLP' => "San Luis Potosí",
            'MX-SIN' => "Sinaloa",
            'MX-SON' => "Sonora",
            'MX-TAB' => "Tabasco",
            'MX-TAM' => "Tamaulipas",
            'MX-TLA' => "Tlaxcala",
            'MX-VER' => "Veracruz",
            'MX-YUC' => "Yucatán",
            'MX-ZAC' => "Zacatecas",
        ],
        "Morocco"              => [
            'MA-AGD' => "Agadir-Ida-Outanane",
            'MA-HAO' => "Al Haouz",
            'MA-HOC' => "Al Hoceïma",
            'MA-AOU' => "Aousserd",
            'MA-ASZ' => "Assa-Zag",
            'MA-AZI' => "Azilal",
            'MA-BES' => "Ben Slimane",
            'MA-BEM' => "Beni Mellal",
            'MA-BER' => "Berkane",
            'MA-BOD' => "Boujdour (EH)",
            'MA-BOM' => "Boulemane",
            'MA-CAS' => "Casablanca [Dar el Beïda]",
            'MA-09'  => "Chaouia-Ouardigha",
            'MA-CHE' => "Chefchaouen",
            'MA-CHI' => "Chichaoua",
            'MA-CHT' => "Chtouka-Ait Baha",
            'MA-10'  => "Doukhala-Abda",
            'MA-HAJ' => "El Hajeb",
            'MA-JDI' => "El Jadida",
            'MA-ERR' => "Errachidia",
            'MA-ESM' => "Es Smara (EH)",
            'MA-ESI' => "Essaouira",
            'MA-FAH' => "Fahs-Beni Makada",
            'MA-FIG' => "Figuig",
            'MA-05'  => "Fès-Boulemane",
            'MA-FES' => "Fès-Dar-Dbibegh",
            'MA-02'  => "Gharb-Chrarda-Beni Hssen",
            'MA-08'  => "Grand Casablanca",
            'MA-GUE' => "Guelmim",
            'MA-14'  => "Guelmim-Es Smara",
            'MA-IFR' => "Ifrane",
            'MA-INE' => "Inezgane-Ait Melloul",
            'MA-JRA' => "Jrada",
            'MA-KES' => "Kelaat es Sraghna",
            'MA-KHE' => "Khemisaet",
            'MA-KHN' => "Khenifra",
            'MA-KHO' => "Khouribga",
            'MA-KEN' => "Kénitra",
            'MA-04'  => "L'Oriental",
            'MA-LAR' => "Larache",
            'MA-LAA' => "Laâyoune (EH)",
            'MA-15'  => "Laâyoune-Boujdour-Sakia el Hamra",
            'MA-MMD' => "Marrakech-Medina",
            'MA-MMN' => "Marrakech-Menara",
            'MA-11'  => "Marrakech-Tensift-Al Haouz",
            'MA-MEK' => "Meknès",
            'MA-06'  => "Meknès-Tafilalet",
            'MA-MOH' => "Mohammadia",
            'MA-MOU' => "Moulay Yacoub",
            'MA-MED' => "Médiouna",
            'MA-NAD' => "Nador",
            'MA-NOU' => "Nouaceur",
            'MA-OUA' => "Ouarzazate",
            'MA-OUD' => "Oued ed Dahab (EH)",
            'MA-16'  => "Oued ed Dahab-Lagouira",
            'MA-OUJ' => "Oujda-Angad",
            'MA-RAB' => "Rabat",
            'MA-07'  => "Rabat-Salé-Zemmour-Zaer",
            'MA-SAF' => "Safi",
            'MA-SAL' => "Salé",
            'MA-SEF' => "Sefrou",
            'MA-SET' => "Settat",
            'MA-SYB' => "Sidi Youssef Ben Ali",
            'MA-SIK' => "Sidl Kacem",
            'MA-SKH' => "Skhirate-Témara",
            'MA-13'  => "Sous-Massa-Draa",
            'MA-12'  => "Tadla-Azilal",
            'MA-TNT' => "Tan-Tan",
            'MA-TNG' => "Tanger-Assilah",
            'MA-01'  => "Tanger-Tétouan",
            'MA-TAO' => "Taounate",
            'MA-TAI' => "Taourirt",
            'MA-TAR' => "Taroudant",
            'MA-TAT' => "Tata",
            'MA-TAZ' => "Taza",
            'MA-03'  => "Taza-Al Hoceima-Taounate",
            'MA-TIZ' => "Tiznit",
            'MA-TET' => "Tétouan",
            'MA-ZAG' => "Zagora",
        ],
        "Netherlands"          => [
            'NL-DR' => "Drenthe",
            'NL-FL' => "Flevoland",
            'NL-FR' => "Friesland",
            'NL-GE' => "Gelderland",
            'NL-GR' => "Groningen",
            'NL-LI' => "Limburg",
            'NL-NB' => "Noord-Brabant",
            'NL-NH' => "Noord-Holland",
            'NL-OV' => "Overijssel",
            'NL-UT' => "Utrecht",
            'NL-ZE' => "Zeeland",
            'NL-ZH' => "Zuid-Holland",
        ],
        "Nigeria"              => [
            'NG-AB' => "Abia",
            'NG-FC' => "Abuja Capital Territory",
            'NG-AD' => "Adamawa",
            'NG-AK' => "Akwa Ibom",
            'NG-AN' => "Anambra",
            'NG-BA' => "Bauchi",
            'NG-BY' => "Bayelsa",
            'NG-BE' => "Benue",
            'NG-BO' => "Borno",
            'NG-CR' => "Cross River",
            'NG-DE' => "Delta",
            'NG-EB' => "Ebonyi",
            'NG-ED' => "Edo",
            'NG-EK' => "Ekiti",
            'NG-EN' => "Enugu",
            'NG-GO' => "Gombe",
            'NG-IM' => "Imo",
            'NG-JI' => "Jigawa",
            'NG-KD' => "Kaduna",
            'NG-KN' => "Kano",
            'NG-KT' => "Katsina",
            'NG-KE' => "Kebbi",
            'NG-KO' => "Kogi",
            'NG-KW' => "Kwara",
            'NG-LA' => "Lagos",
            'NG-NA' => "Nassarawa",
            'NG-NI' => "Niger, Níger",
            'NG-OG' => "Ogun",
            'NG-ON' => "Ondo",
            'NG-OS' => "Osun",
            'NG-OY' => "Oyo",
            'NG-PL' => "Plateau",
            'NG-RI' => "Rivers",
            'NG-SO' => "Sokoto",
            'NG-TA' => "Taraba",
            'NG-YO' => "Yobe",
            'NG-ZA' => "Zamfara",
        ],
        "Norway"               => [
            'NO-02' => "Akershus",
            'NO-09' => "Aust-Agder",
            'NO-06' => "Buskerud",
            'NO-20' => "Finnmark",
            'NO-04' => "Hedmark",
            'NO-12' => "Hordaland",
            'NO-22' => "Jan Mayen",
            'NO-15' => "Møre og Romsdal",
            'NO-17' => "Nord-Trøndelag",
            'NO-18' => "Nordland",
            'NO-05' => "Oppland",
            'NO-03' => "Oslo",
            'NO-11' => "Rogaland",
            'NO-14' => "Sogn og Fjordane",
            'NO-21' => "Svalbard",
            'NO-16' => "Sør-Trøndelag",
            'NO-08' => "Telemark",
            'NO-19' => "Troms",
            'NO-10' => "Vest-Agder",
            'NO-07' => "Vestfold",
            'NO-01' => "Østfold",
        ],
        "Philippines"          => [
            'PH-ABR' => "Abra",
            'PH-AGN' => "Agusan del Norte",
            'PH-AGS' => "Agusan del Sur",
            'PH-AKL' => "Aklan",
            'PH-ALB' => "Albay",
            'PH-ANT' => "Antique",
            'PH-APA' => "Apayao",
            'PH-AUR' => "Aurora",
            'PH-14'  => "Autonomous Region in Muslim Mindanao (ARMM)",
            'PH-BAS' => "Basilan",
            'PH-BTN' => "Batanes",
            'PH-BTG' => "Batangas",
            'PH-BAN' => "Batasn",
            'PH-BEN' => "Benguet",
            'PH-05'  => "Bicol (Region V)",
            'PH-BIL' => "Biliran",
            'PH-BOH' => "Bohol",
            'PH-BUK' => "Bukidnon",
            'PH-BUL' => "Bulacan",
            'PH-40'  => "CALABARZON (Region IV-A)",
            'PH-CAG' => "Cagayan",
            'PH-02'  => "Cagayan Valley (Region II)",
            'PH-CAN' => "Camarines Norte",
            'PH-CAS' => "Camarines Sur",
            'PH-CAM' => "Camiguin",
            'PH-CAP' => "Capiz",
            'PH-13'  => "Caraga (Region XIII)",
            'PH-CAT' => "Catanduanes",
            'PH-CAV' => "Cavite",
            'PH-CEB' => "Cebu",
            'PH-03'  => "Central Luzon (Region III)",
            'PH-07'  => "Central Visayas (Region VII)",
            'PH-COM' => "Compostela Valley",
            'PH-15'  => "Cordillera Administrative Region (CAR)",
            'PH-11'  => "Davao (Region XI)",
            'PH-DAO' => "Davao Oriental",
            'PH-DAV' => "Davao del Norte",
            'PH-DAS' => "Davao del Sur",
            'PH-DIN' => "Dinagat Islands",
            'PH-EAS' => "Eastern Samar",
            'PH-08'  => "Eastern Visayas (Region VIII)",
            'PH-GUI' => "Guimaras",
            'PH-IFU' => "Ifugao",
            'PH-01'  => "Ilocos (Region I)",
            'PH-ILN' => "Ilocos Norte",
            'PH-ILS' => "Ilocos Sur",
            'PH-ILI' => "Iloilo",
            'PH-ISA' => "Isabela",
            'PH-KAL' => "Kalinga-Apayso",
            'PH-LUN' => "La Union",
            'PH-LAG' => "Laguna",
            'PH-LAN' => "Lanao del Norte",
            'PH-LAS' => "Lanao del Sur",
            'PH-LEY' => "Leyte",
            'PH-41'  => "MIMAROPA (Region IV-B)",
            'PH-MAG' => "Maguindanao",
            'PH-MAD' => "Marinduque",
            'PH-MAS' => "Masbate",
            'PH-MDC' => "Mindoro Occidental",
            'PH-MDR' => "Mindoro Oriental",
            'PH-MSC' => "Misamis Occidental",
            'PH-MSR' => "Misamis Oriental",
            'PH-MOU' => "Mountain Province",
            'PH-00'  => "National Capital Region",
            'PH-NEC' => "Negroe Occidental",
            'PH-NER' => "Negros Oriental",
            'PH-NCO' => "North Cotabato",
            'PH-10'  => "Northern Mindanao (Region X)",
            'PH-NSA' => "Northern Samar",
            'PH-NUE' => "Nueva Ecija",
            'PH-NUV' => "Nueva Vizcaya",
            'PH-PLW' => "Palawan",
            'PH-PAM' => "Pampanga",
            'PH-PAN' => "Pangasinan",
            'PH-QUE' => "Quezon",
            'PH-QUI' => "Quirino",
            'PH-RIZ' => "Rizal",
            'PH-ROM' => "Romblon",
            'PH-SAR' => "Sarangani",
            'PH-SIG' => "Siquijor",
            'PH-12'  => "Soccsksargen (Region XII)",
            'PH-SOR' => "Sorsogon",
            'PH-SCO' => "South Cotabato",
            'PH-SLE' => "Southern Leyte",
            'PH-SUK' => "Sultan Kudarat",
            'PH-SLU' => "Sulu",
            'PH-SUN' => "Surigao del Norte",
            'PH-SUR' => "Surigao del Sur",
            'PH-TAR' => "Tarlac",
            'PH-TAW' => "Tawi-Tawi",
            'PH-WSA' => "Western Samar",
            'PH-06'  => "Western Visayas (Region VI)",
            'PH-ZMB' => "Zambales",
            'PH-09'  => "Zamboanga Peninsula (Region IX)",
            'PH-ZSI' => "Zamboanga Sibugay",
            'PH-ZAN' => "Zamboanga del Norte",
            'PH-ZAS' => "Zamboanga del Sur",
        ],
        "Poland"               => [
            'PL-DS' => "Dolnośląskie",
            'PL-KP' => "Kujawsko-pomorskie",
            'PL-LU' => "Lubelskie",
            'PL-LB' => "Lubuskie",
            'PL-MZ' => "Mazowieckie",
            'PL-MA' => "Małopolskie",
            'PL-OP' => "Opolskie",
            'PL-PK' => "Podkarpackie",
            'PL-PD' => "Podlaskie",
            'PL-PM' => "Pomorskie",
            'PL-WN' => "Warmińsko-mazurskie",
            'PL-WP' => "Wielkopolskie",
            'PL-ZP' => "Zachodniopomorskie",
            'PL-LD' => "Łódzkie",
            'PL-SL' => "Śląskie",
            'PL-SK' => "Świętokrzyskie",
        ],
        "Portugal"             => [
            'PT-01' => "Aveiro",
            'PT-02' => "Beja",
            'PT-03' => "Braga",
            'PT-04' => "Bragança",
            'PT-05' => "Castelo Branco",
            'PT-06' => "Coimbra",
            'PT-08' => "Faro",
            'PT-09' => "Guarda",
            'PT-10' => "Leiria",
            'PT-11' => "Lisboa",
            'PT-12' => "Portalegre",
            'PT-13' => "Porto",
            'PT-30' => "Região Autónoma da Madeira",
            'PT-20' => "Região Autónoma dos Açores",
            'PT-14' => "Santarém",
            'PT-15' => "Setúbal",
            'PT-16' => "Viana do Castelo",
            'PT-17' => "Vila Real",
            'PT-18' => "Viseu",
            'PT-07' => "Évora",
        ],
        "Romania"              => [
            'RO-AB' => "Alba",
            'RO-AR' => "Arad",
            'RO-AG' => "Argeș",
            'RO-BC' => "Bacău",
            'RO-BH' => "Bihor",
            'RO-BN' => "Bistrița-Năsăud",
            'RO-BT' => "Botoșani",
            'RO-BV' => "Brașov",
            'RO-BR' => "Brăila",
            'RO-B'  => "București",
            'RO-BZ' => "Buzău",
            'RO-CS' => "Caraș-Severin",
            'RO-CJ' => "Cluj",
            'RO-CT' => "Constanța",
            'RO-CV' => "Covasna",
            'RO-CL' => "Călărași",
            'RO-DJ' => "Dolj",
            'RO-DB' => "Dâmbovița",
            'RO-GL' => "Galați",
            'RO-GR' => "Giurgiu",
            'RO-GJ' => "Gorj",
            'RO-HR' => "Harghita",
            'RO-HD' => "Hunedoara",
            'RO-IL' => "Ialomița",
            'RO-IS' => "Iași",
            'RO-IF' => "Ilfov",
            'RO-MM' => "Maramureș",
            'RO-MH' => "Mehedinți",
            'RO-MS' => "Mureș",
            'RO-NT' => "Neamț",
            'RO-OT' => "Olt",
            'RO-PH' => "Prahova",
            'RO-SM' => "Satu Mare",
            'RO-SB' => "Sibiu",
            'RO-SV' => "Suceava",
            'RO-SJ' => "Sălaj",
            'RO-TR' => "Teleorman",
            'RO-TM' => "Timiș",
            'RO-TL' => "Tulcea",
            'RO-VS' => "Vaslui",
            'RO-VN' => "Vrancea",
            'RO-VL' => "Vâlcea",
        ],
        "Russian Federation"   => [
            'RU-AD'  => "Adygeya, Respublika",
            'RU-AL'  => "Altay, Respublika",
            'RU-ALT' => "Altayskiy kray",
            'RU-AMU' => "Amurskaya oblast'",
            'RU-ARK' => "Arkhangel'skaya oblast'",
            'RU-AST' => "Astrakhanskaya oblast'",
            'RU-BA'  => "Bashkortostan, Respublika",
            'RU-BEL' => "Belgorodskaya oblast'",
            'RU-BRY' => "Bryanskaya oblast'",
            'RU-BU'  => "Buryatiya, Respublika",
            'RU-CE'  => "Chechenskaya Respublika",
            'RU-CHE' => "Chelyabinskaya oblast'",
            'RU-CHU' => "Chukotskiy avtonomnyy okrug",
            'RU-CU'  => "Chuvashskaya Respublika",
            'RU-DA'  => "Dagestan, Respublika",
            'RU-IRK' => "Irkutiskaya oblast'",
            'RU-IVA' => "Ivanovskaya oblast'",
            'RU-KB'  => "Kabardino-Balkarskaya Respublika",
            'RU-KGD' => "Kaliningradskaya oblast'",
            'RU-KL'  => "Kalmykiya, Respublika",
            'RU-KLU' => "Kaluzhskaya oblast'",
            'RU-KAM' => "Kamchatskiy kray",
            'RU-KC'  => "Karachayevo-Cherkesskaya Respublika",
            'RU-KR'  => "Kareliya, Respublika",
            'RU-KEM' => "Kemerovskaya oblast'",
            'RU-KHA' => "Khabarovskiy kray",
            'RU-KK'  => "Khakasiya, Respublika",
            'RU-KHM' => "Khanty-Mansiysky avtonomnyy okrug-Yugra",
            'RU-KIR' => "Kirovskaya oblast'",
            'RU-KO'  => "Komi, Respublika",
            'RU-KOS' => "Kostromskaya oblast'",
            'RU-KDA' => "Krasnodarskiy kray",
            'RU-KYA' => "Krasnoyarskiy kray",
            'RU-KGN' => "Kurganskaya oblast'",
            'RU-KRS' => "Kurskaya oblast'",
            'RU-LEN' => "Leningradskaya oblast'",
            'RU-LIP' => "Lipetskaya oblast'",
            'RU-MAG' => "Magadanskaya oblast'",
            'RU-ME'  => "Mariy El, Respublika",
            'RU-MO'  => "Mordoviya, Respublika",
            'RU-MOS' => "Moskovskaya oblast'",
            'RU-MOW' => "Moskva",
            'RU-MUR' => "Murmanskaya oblast'",
            'RU-NEN' => "Nenetskiy avtonomnyy okrug",
            'RU-NIZ' => "Nizhegorodskaya oblast'",
            'RU-NGR' => "Novgorodskaya oblast'",
            'RU-NVS' => "Novosibirskaya oblast'",
            'RU-OMS' => "Omskaya oblast'",
            'RU-ORE' => "Orenburgskaya oblast'",
            'RU-ORL' => "Orlovskaya oblast'",
            'RU-PNZ' => "Penzenskaya oblast'",
            'RU-PER' => "Permskiy kray",
            'RU-PRI' => "Primorskiy kray",
            'RU-PSK' => "Pskovskaya oblast'",
            'RU-IN'  => "Respublika Ingushetiya",
            'RU-ROS' => "Rostovskaya oblast'",
            'RU-RYA' => "Ryazanskaya oblast'",
            'RU-SA'  => "Sakha, Respublika [Yakutiya]",
            'RU-SAK' => "Sakhalinskaya oblast'",
            'RU-SAM' => "Samaraskaya oblast'",
            'RU-SPE' => "Sankt-Peterburg",
            'RU-SAR' => "Saratovskaya oblast'",
            'RU-SE'  => "Severnaya Osetiya-Alaniya, Respublika",
            'RU-SMO' => "Smolenskaya oblast'",
            'RU-STA' => "Stavropol'skiy kray",
            'RU-SVE' => "Sverdlovskaya oblast'",
            'RU-TAM' => "Tambovskaya oblast'",
            'RU-TA'  => "Tatarstan, Respublika",
            'RU-TOM' => "Tomskaya oblast'",
            'RU-TUL' => "Tul'skaya oblast'",
            'RU-TVE' => "Tverskaya oblast'",
            'RU-TYU' => "Tyumenskaya oblast'",
            'RU-TY'  => "Tyva, Respublika [Tuva]",
            'RU-UD'  => "Udmurtskaya Respublika",
            'RU-ULY' => "Ul'yanovskaya oblast'",
            'RU-VLA' => "Vladimirskaya oblast'",
            'RU-VGG' => "Volgogradskaya oblast'",
            'RU-VLG' => "Vologodskaya oblast'",
            'RU-VOR' => "Voronezhskaya oblast'",
            'RU-YAN' => "Yamalo-Nenetskiy avtonomnyy okrug",
            'RU-YAR' => "Yaroslavskaya oblast'",
            'RU-YEV' => "Yevreyskaya avtonomnaya oblast'",
            'RU-ZAB' => "Zabajkal'skij kraj",
        ],
        "Slovakia"             => [
            'SK-BC' => "Banskobystrický kraj",
            'SK-BL' => "Bratislavský kraj",
            'SK-KI' => "Košický kraj",
            'SK-NI' => "Nitriansky kraj",
            'SK-PV' => "Prešovský kraj",
            'SK-TC' => "Trenčiansky kraj",
            'SK-TA' => "Trnavský kraj",
            'SK-ZI' => "Žilinský kraj",
        ],
        "Slovenia"             => [
            'SI-001' => "Ajdovščina",
            'SI-195' => "Apače",
            'SI-002' => "Beltinci",
            'SI-148' => "Benedikt",
            'SI-149' => "Bistrica ob Sotli",
            'SI-003' => "Bled",
            'SI-150' => "Bloke",
            'SI-004' => "Bohinj",
            'SI-005' => "Borovnica",
            'SI-006' => "Bovec",
            'SI-151' => "Braslovče",
            'SI-007' => "Brda",
            'SI-008' => "Brezovica",
            'SI-009' => "Brežice",
            'SI-152' => "Cankova",
            'SI-011' => "Celje",
            'SI-012' => "Cerklje na Gorenjskem",
            'SI-013' => "Cerknica",
            'SI-014' => "Cerkno",
            'SI-153' => "Cerkvenjak",
            'SI-196' => "Cirkulane",
            'SI-018' => "Destrnik",
            'SI-019' => "Divača",
            'SI-154' => "Dobje",
            'SI-020' => "Dobrepolje",
            'SI-155' => "Dobrna",
            'SI-021' => "Dobrova-Polhov Gradec",
            'SI-156' => "Dobrovnik/Dobronak",
            'SI-022' => "Dol pri Ljubljani",
            'SI-157' => "Dolenjske Toplice",
            'SI-023' => "Domžale",
            'SI-024' => "Dornava",
            'SI-025' => "Dravograd",
            'SI-026' => "Duplek",
            'SI-027' => "Gorenja vas-Poljane",
            'SI-028' => "Gorišnica",
            'SI-207' => "Gorje",
            'SI-029' => "Gornja Radgona",
            'SI-030' => "Gornji Grad",
            'SI-031' => "Gornji Petrovci",
            'SI-158' => "Grad",
            'SI-032' => "Grosuplje",
            'SI-159' => "Hajdina",
            'SI-161' => "Hodoš/Hodos",
            'SI-162' => "Horjul",
            'SI-160' => "Hoče-Slivnica",
            'SI-034' => "Hrastnik",
            'SI-035' => "Hrpelje-Kozina",
            'SI-036' => "Idrija",
            'SI-037' => "Ig",
            'SI-038' => "Ilirska Bistrica",
            'SI-039' => "Ivančna Gorica",
            'SI-040' => "Izola/Isola",
            'SI-041' => "Jesenice",
            'SI-163' => "Jezersko",
            'SI-042' => "Juršinci",
            'SI-043' => "Kamnik",
            'SI-044' => "Kanal",
            'SI-045' => "Kidričevo",
            'SI-046' => "Kobarid",
            'SI-047' => "Kobilje",
            'SI-049' => "Komen",
            'SI-164' => "Komenda",
            'SI-050' => "Koper/Capodistria",
            'SI-197' => "Kosanjevica na Krki",
            'SI-165' => "Kostel",
            'SI-051' => "Kozje",
            'SI-048' => "Kočevje",
            'SI-052' => "Kranj",
            'SI-053' => "Kranjska Gora",
            'SI-166' => "Križevci",
            'SI-054' => "Krško",
            'SI-055' => "Kungota",
            'SI-056' => "Kuzma",
            'SI-057' => "Laško",
            'SI-058' => "Lenart",
            'SI-059' => "Lendava/Lendva",
            'SI-060' => "Litija",
            'SI-061' => "Ljubljana",
            'SI-062' => "Ljubno",
            'SI-063' => "Ljutomer",
            'SI-208' => "Log-Dragomer",
            'SI-064' => "Logatec",
            'SI-167' => "Lovrenc na Pohorju",
            'SI-065' => "Loška dolina",
            'SI-066' => "Loški Potok",
            'SI-068' => "Lukovica",
            'SI-067' => "Luče",
            'SI-069' => "Majšperk",
            'SI-198' => "Makole",
            'SI-070' => "Maribor",
            'SI-168' => "Markovci",
            'SI-071' => "Medvode",
            'SI-072' => "Mengeš",
            'SI-073' => "Metlika",
            'SI-074' => "Mežica",
            'SI-169' => "Miklavž na Dravskem polju",
            'SI-075' => "Miren-Kostanjevica",
            'SI-170' => "Mirna Peč",
            'SI-076' => "Mislinja",
            'SI-199' => "Mokronog-Trebelno",
            'SI-078' => "Moravske Toplice",
            'SI-077' => "Moravče",
            'SI-079' => "Mozirje",
            'SI-080' => "Murska Sobota",
            'SI-081' => "Muta",
            'SI-082' => "Naklo",
            'SI-083' => "Nazarje",
            'SI-084' => "Nova Gorica",
            'SI-085' => "Novo mesto",
            'SI-086' => "Odranci",
            'SI-171' => "Oplotnica",
            'SI-087' => "Ormož",
            'SI-088' => "Osilnica",
            'SI-089' => "Pesnica",
            'SI-090' => "Piran/Pirano",
            'SI-091' => "Pivka",
            'SI-172' => "Podlehnik",
            'SI-093' => "Podvelka",
            'SI-092' => "Podčetrtek",
            'SI-200' => "Poljčane",
            'SI-173' => "Polzela",
            'SI-094' => "Postojna",
            'SI-174' => "Prebold",
            'SI-095' => "Preddvor",
            'SI-175' => "Prevalje",
            'SI-096' => "Ptuj",
            'SI-097' => "Puconci",
            'SI-100' => "Radenci",
            'SI-099' => "Radeče",
            'SI-101' => "Radlje ob Dravi",
            'SI-102' => "Radovljica",
            'SI-103' => "Ravne na Koroškem",
            'SI-176' => "Razkrižje",
            'SI-098' => "Rače-Fram",
            'SI-201' => "Renče-Vogrsko",
            'SI-209' => "Rečica ob Savinji",
            'SI-104' => "Ribnica",
            'SI-177' => "Ribnica na Pohorju",
            'SI-107' => "Rogatec",
            'SI-106' => "Rogaška Slatina",
            'SI-105' => "Rogašovci",
            'SI-108' => "Ruše",
            'SI-178' => "Selnica ob Dravi",
            'SI-109' => "Semič",
            'SI-110' => "Sevnica",
            'SI-111' => "Sežana",
            'SI-112' => "Slovenj Gradec",
            'SI-113' => "Slovenska Bistrica",
            'SI-114' => "Slovenske Konjice",
            'SI-179' => "Sodražica",
            'SI-180' => "Solčava",
            'SI-202' => "Središče ob Dravi",
            'SI-115' => "Starče",
            'SI-203' => "Straža",
            'SI-181' => "Sveta Ana",
            'SI-182' => "Sveta Andraž v Slovenskih Goricah",
            'SI-204' => "Sveta Trojica v Slovenskih Goricah",
            'SI-116' => "Sveti Jurij",
            'SI-210' => "Sveti Jurij v Slovenskih Goricah",
            'SI-205' => "Sveti Tomaž",
            'SI-184' => "Tabor",
            'SI-010' => "Tišina",
            'SI-128' => "Tolmin",
            'SI-129' => "Trbovlje",
            'SI-130' => "Trebnje",
            'SI-185' => "Trnovska vas",
            'SI-186' => "Trzin",
            'SI-131' => "Tržič",
            'SI-132' => "Turnišče",
            'SI-133' => "Velenje",
            'SI-187' => "Velika Polana",
            'SI-134' => "Velike Lašče",
            'SI-188' => "Veržej",
            'SI-135' => "Videm",
            'SI-136' => "Vipava",
            'SI-137' => "Vitanje",
            'SI-138' => "Vodice",
            'SI-139' => "Vojnik",
            'SI-189' => "Vransko",
            'SI-140' => "Vrhnika",
            'SI-141' => "Vuzenica",
            'SI-142' => "Zagorje ob Savi",
            'SI-143' => "Zavrč",
            'SI-144' => "Zreče",
            'SI-015' => "Črenšovci",
            'SI-016' => "Črna na Koroškem",
            'SI-017' => "Črnomelj",
            'SI-033' => "Šalovci",
            'SI-183' => "Šempeter-Vrtojba",
            'SI-118' => "Šentilj",
            'SI-119' => "Šentjernej",
            'SI-120' => "Šentjur",
            'SI-211' => "Šentrupert",
            'SI-117' => "Šenčur",
            'SI-121' => "Škocjan",
            'SI-122' => "Škofja Loka",
            'SI-123' => "Škofljica",
            'SI-124' => "Šmarje pri Jelšah",
            'SI-206' => "Šmarjeske Topliče",
            'SI-125' => "Šmartno ob Paki",
            'SI-194' => "Šmartno pri Litiji",
            'SI-126' => "Šoštanj",
            'SI-127' => "Štore",
            'SI-190' => "Žalec",
            'SI-146' => "Železniki",
            'SI-191' => "Žetale",
            'SI-147' => "Žiri",
            'SI-192' => "Žirovnica",
            'SI-193' => "Žužemberk",
        ],
        "South Africa"         => [
            'ZA-EC' => "Eastern Cape",
            'ZA-FS' => "Free State",
            'ZA-GT' => "Gauteng",
            'ZA-NL' => "Kwazulu-Natal",
            'ZA-LP' => "Limpopo",
            'ZA-MP' => "Mpumalanga",
            'ZA-NW' => "North-West (South Africa)",
            'ZA-NC' => "Northern Cape",
            'ZA-WC' => "Western Cape",
        ],
        "Spain"                => [
            'ES-C'  => "A Coruña",
            'ES-AB' => "Albacete",
            'ES-A'  => "Alicante",
            'ES-AL' => "Almería",
            'ES-AN' => "Andalucía",
            'ES-AR' => "Aragón",
            'ES-O'  => "Asturias",
            'ES-AS' => "Asturias, Principado de",
            'ES-BA' => "Badajoz",
            'ES-PM' => "Balears",
            'ES-B'  => "Barcelona",
            'ES-BU' => "Burgos",
            'ES-CN' => "Canarias",
            'ES-S'  => "Cantabria",
            'ES-CS' => "Castellón",
            'ES-CL' => "Castilla y León",
            'ES-CM' => "Castilla-La Mancha",
            'ES-CT' => "Catalunya",
            'ES-CE' => "Ceuta",
            'ES-CR' => "Ciudad Real",
            'ES-CU' => "Cuenca",
            'ES-CC' => "Cáceres",
            'ES-CA' => "Cádiz",
            'ES-CO' => "Córdoba",
            'ES-EX' => "Extremadura",
            'ES-GA' => "Galicia",
            'ES-GI' => "Girona",
            'ES-GR' => "Granada",
            'ES-GU' => "Guadalajara",
            'ES-SS' => "Guipúzcoa / Gipuzkoa",
            'ES-H'  => "Huelva",
            'ES-HU' => "Huesca",
            'ES-IB' => "Illes Balears",
            'ES-J'  => "Jaén",
            'ES-LO' => "La Rioja",
            'ES-GC' => "Las Palmas",
            'ES-LE' => "León",
            'ES-L'  => "Lleida",
            'ES-LU' => "Lugo",
            'ES-M'  => "Madrid",
            'ES-MD' => "Madrid, Comunidad de",
            'ES-ML' => "Melilla",
            'ES-MU' => "Murcia",
            'ES-MC' => "Murcia, Región de",
            'ES-MA' => "Málaga",
            'ES-NA' => "Navarra / Nafarroa",
            'ES-NC' => "Navarra, Comunidad Foral de / Nafarroako Foru Komunitatea",
            'ES-OR' => "Ourense",
            'ES-P'  => "Palencia",
            'ES-PV' => "País Vasco / Euskal Herria",
            'ES-PO' => "Pontevedra",
            'ES-SA' => "Salamanca",
            'ES-TF' => "Santa Cruz de Tenerife",
            'ES-SG' => "Segovia",
            'ES-SE' => "Sevilla",
            'ES-SO' => "Soria",
            'ES-T'  => "Tarragona",
            'ES-TE' => "Teruel",
            'ES-TO' => "Toledo",
            'ES-V'  => "Valencia / València",
            'ES-VC' => "Valenciana, Comunidad / Valenciana, Comunitat",
            'ES-VA' => "Valladolid",
            'ES-BI' => "Vizcayaa / Bizkaia",
            'ES-ZA' => "Zamora",
            'ES-Z'  => "Zaragoza",
            'ES-VI' => "Álava",
            'ES-AV' => "Ávila",
        ],
        "Sweden"               => [
            'SE-K'  => "Blekinge län",
            'SE-W'  => "Dalarnas län",
            'SE-I'  => "Gotlands län",
            'SE-X'  => "Gävleborgs län",
            'SE-N'  => "Hallands län",
            'SE-Z'  => "Jämtlande län",
            'SE-F'  => "Jönköpings län",
            'SE-H'  => "Kalmar län",
            'SE-G'  => "Kronobergs län",
            'SE-BD' => "Norrbottens län",
            'SE-M'  => "Skåne län",
            'SE-AB' => "Stockholms län",
            'SE-D'  => "Södermanlands län",
            'SE-C'  => "Uppsala län",
            'SE-S'  => "Värmlands län",
            'SE-AC' => "Västerbottens län",
            'SE-Y'  => "Västernorrlands län",
            'SE-U'  => "Västmanlands län",
            'SE-O'  => "Västra Götalands län",
            'SE-T'  => "Örebro län",
            'SE-E'  => "Östergötlands län",
        ],
        "Switzerland"          => [
            'CH-AG' => "Aargau",
            'CH-AR' => "Appenzell Ausserrhoden",
            'CH-AI' => "Appenzell Innerrhoden",
            'CH-BL' => "Basel-Landschaft",
            'CH-BS' => "Basel-Stadt",
            'CH-BE' => "Bern",
            'CH-FR' => "Fribourg",
            'CH-GE' => "Genève",
            'CH-GL' => "Glarus",
            'CH-GR' => "Graubünden",
            'CH-JU' => "Jura",
            'CH-LU' => "Luzern",
            'CH-NE' => "Neuchâtel",
            'CH-NW' => "Nidwalden",
            'CH-OW' => "Obwalden",
            'CH-SG' => "Sankt Gallen",
            'CH-SH' => "Schaffhausen",
            'CH-SZ' => "Schwyz",
            'CH-SO' => "Solothurn",
            'CH-TG' => "Thurgau",
            'CH-TI' => "Ticino",
            'CH-UR' => "Uri",
            'CH-VS' => "Valais",
            'CH-VD' => "Vaud",
            'CH-ZG' => "Zug",
            'CH-ZH' => "Zürich",
        ],
        "Taiwan"               => [
            'TW-CHA' => "Changhua",
            'TW-CYI' => "Chiay City",
            'TW-CYQ' => "Chiayi",
            'TW-HSQ' => "Hsinchu",
            'TW-HSZ' => "Hsinchui City",
            'TW-HUA' => "Hualien",
            'TW-ILA' => "Ilan",
            'TW-KHQ' => "Kaohsiung",
            'TW-KHH' => "Kaohsiung City",
            'TW-KEE' => "Keelung City",
            'TW-MIA' => "Miaoli",
            'TW-NAN' => "Nantou",
            'TW-PEN' => "Penghu",
            'TW-PIF' => "Pingtung",
            'TW-TXQ' => "Taichung",
            'TW-TXG' => "Taichung City",
            'TW-TNQ' => "Tainan",
            'TW-TNN' => "Tainan City",
            'TW-TPQ' => "Taipei",
            'TW-TPE' => "Taipei City",
            'TW-TTT' => "Taitung",
            'TW-TAO' => "Taoyuan",
            'TW-YUN' => "Yunlin",
        ],
        "Thailand"             => [
            'TH-37' => "Amnat Charoen",
            'TH-15' => "Ang Thong",
            'TH-31' => "Buri Ram",
            'TH-24' => "Chachoengsao",
            'TH-18' => "Chai Nat",
            'TH-36' => "Chaiyaphum",
            'TH-22' => "Chanthaburi",
            'TH-50' => "Chiang Mai",
            'TH-57' => "Chiang Rai",
            'TH-20' => "Chon Buri",
            'TH-86' => "Chumphon",
            'TH-46' => "Kalasin",
            'TH-62' => "Kamphaeng Phet",
            'TH-71' => "Kanchanaburi",
            'TH-40' => "Khon Kaen",
            'TH-81' => "Krabi",
            'TH-10' => "Krung Thep Maha Nakhon Bangkok",
            'TH-52' => "Lampang",
            'TH-51' => "Lamphun",
            'TH-42' => "Loei",
            'TH-16' => "Lop Buri",
            'TH-58' => "Mae Hong Son",
            'TH-44' => "Maha Sarakham",
            'TH-49' => "Mukdahan",
            'TH-26' => "Nakhon Nayok",
            'TH-73' => "Nakhon Pathom",
            'TH-48' => "Nakhon Phanom",
            'TH-30' => "Nakhon Ratchasima",
            'TH-60' => "Nakhon Sawan",
            'TH-80' => "Nakhon Si Thammarat",
            'TH-55' => "Nan",
            'TH-96' => "Narathiwat",
            'TH-39' => "Nong Bua Lam Phu",
            'TH-43' => "Nong Khai",
            'TH-12' => "Nonthaburi",
            'TH-13' => "Pathum Thani",
            'TH-94' => "Pattani",
            'TH-82' => "Phangnga",
            'TH-93' => "Phatthalung",
            'TH-S'  => "Phatthaya",
            'TH-56' => "Phayao",
            'TH-67' => "Phetchabun",
            'TH-76' => "Phetchaburi",
            'TH-66' => "Phichit",
            'TH-65' => "Phitsanulok",
            'TH-14' => "Phra Nakhon Si Ayutthaya",
            'TH-54' => "Phrae",
            'TH-83' => "Phuket",
            'TH-25' => "Prachin Buri",
            'TH-77' => "Prachuap Khiri Khan",
            'TH-85' => "Ranong",
            'TH-70' => "Ratchaburi",
            'TH-21' => "Rayong",
            'TH-45' => "Roi Et",
            'TH-27' => "Sa Kaeo",
            'TH-47' => "Sakon Nakhon",
            'TH-11' => "Samut Prakan",
            'TH-74' => "Samut Sakhon",
            'TH-75' => "Samut Songkhram",
            'TH-19' => "Saraburi",
            'TH-91' => "Satun",
            'TH-33' => "Si Sa Ket",
            'TH-17' => "Sing Buri",
            'TH-90' => "Songkhla",
            'TH-64' => "Sukhothai",
            'TH-72' => "Suphan Buri",
            'TH-84' => "Surat Thani",
            'TH-32' => "Surin",
            'TH-63' => "Tak",
            'TH-92' => "Trang",
            'TH-23' => "Trat",
            'TH-34' => "Ubon Ratchathani",
            'TH-41' => "Udon Thani",
            'TH-61' => "Uthai Thani",
            'TH-53' => "Uttaradit",
            'TH-95' => "Yala",
            'TH-35' => "Yasothon",
        ],
        "Turkey"               => [
            'TR-01' => "Adana",
            'TR-02' => "Adıyaman",
            'TR-03' => "Afyon",
            'TR-68' => "Aksaray",
            'TR-05' => "Amasya",
            'TR-06' => "Ankara",
            'TR-07' => "Antalya",
            'TR-75' => "Ardahan",
            'TR-08' => "Artvin",
            'TR-09' => "Aydın",
            'TR-04' => "Ağrı",
            'TR-10' => "Balıkesir",
            'TR-74' => "Bartın",
            'TR-72' => "Batman",
            'TR-69' => "Bayburt",
            'TR-11' => "Bilecik",
            'TR-12' => "Bingöl",
            'TR-13' => "Bitlis",
            'TR-14' => "Bolu",
            'TR-15' => "Burdur",
            'TR-16' => "Bursa",
            'TR-20' => "Denizli",
            'TR-21' => "Diyarbakır",
            'TR-81' => "Düzce",
            'TR-22' => "Edirne",
            'TR-23' => "Elazığ",
            'TR-24' => "Erzincan",
            'TR-25' => "Erzurum",
            'TR-26' => "Eskişehir",
            'TR-27' => "Gaziantep",
            'TR-28' => "Giresun",
            'TR-29' => "Gümüşhane",
            'TR-30' => "Hakkâri",
            'TR-31' => "Hatay",
            'TR-32' => "Isparta",
            'TR-76' => "Iğdır",
            'TR-46' => "Kahramanmaraş",
            'TR-78' => "Karabük",
            'TR-70' => "Karaman",
            'TR-36' => "Kars",
            'TR-37' => "Kastamonu",
            'TR-38' => "Kayseri",
            'TR-79' => "Kilis",
            'TR-41' => "Kocaeli",
            'TR-42' => "Konya",
            'TR-43' => "Kütahya",
            'TR-39' => "Kırklareli",
            'TR-71' => "Kırıkkale",
            'TR-40' => "Kırşehir",
            'TR-44' => "Malatya",
            'TR-45' => "Manisa",
            'TR-47' => "Mardin",
            'TR-48' => "Muğla",
            'TR-49' => "Muş",
            'TR-50' => "Nevşehir",
            'TR-51' => "Niğde",
            'TR-52' => "Ordu",
            'TR-80' => "Osmaniye",
            'TR-53' => "Rize",
            'TR-54' => "Sakarya",
            'TR-55' => "Samsun",
            'TR-56' => "Siirt",
            'TR-57' => "Sinop",
            'TR-58' => "Sivas",
            'TR-59' => "Tekirdağ",
            'TR-60' => "Tokat",
            'TR-61' => "Trabzon",
            'TR-62' => "Tunceli",
            'TR-64' => "Uşak",
            'TR-65' => "Van",
            'TR-77' => "Yalova",
            'TR-66' => "Yozgat",
            'TR-67' => "Zonguldak",
            'TR-17' => "Çanakkale",
            'TR-18' => "Çankırı",
            'TR-19' => "Çorum",
            'TR-34' => "İstanbul",
            'TR-35' => "İzmir",
            'TR-33' => "İçel",
            'TR-63' => "Şanlıurfa",
            'TR-73' => "Şırnak",
        ],
        "Ukraine"              => [
            'UA-71' => "Cherkas'ka Oblast'",
            'UA-74' => "Chernihivs'ka Oblast'",
            'UA-77' => "Chernivets'ka Oblast'",
            'UA-12' => "Dnipropetrovs'ka Oblast'",
            'UA-14' => "Donets'ka Oblast'",
            'UA-26' => "Ivano-Frankivs'ka Oblast'",
            'UA-63' => "Kharkivs'ka Oblast'",
            'UA-65' => "Khersons'ka Oblast'",
            'UA-68' => "Khmel'nyts'ka Oblast'",
            'UA-35' => "Kirovohrads'ka Oblast'",
            'UA-32' => "Kyïvs'ka Oblast'",
            'UA-30' => "Kyïvs'ka mis'ka rada",
            'UA-46' => "L'vivs'ka Oblast'",
            'UA-09' => "Luhans'ka Oblast'",
            'UA-48' => "Mykolaïvs'ka Oblast'",
            'UA-51' => "Odes'ka Oblast'",
            'UA-53' => "Poltavs'ka Oblast'",
            'UA-43' => "Respublika Krym",
            'UA-56' => "Rivnens'ka Oblast'",
            'UA-40' => "Sevastopol",
            'UA-59' => "Sums 'ka Oblast'",
            'UA-61' => "Ternopil's'ka Oblast'",
            'UA-05' => "Vinnyts'ka Oblast'",
            'UA-07' => "Volyns'ka Oblast'",
            'UA-21' => "Zakarpats'ka Oblast'",
            'UA-23' => "Zaporiz'ka Oblast'",
            'UA-18' => "Zhytomyrs'ka Oblast'",
        ],
        "United Arab Emirates" => [
            'AE-AJ' => "'Ajmān",
            'AE-AZ' => "Abū Ȥaby [Abu Dhabi]",
            'AE-FU' => "Al Fujayrah",
            'AE-SH' => "Ash Shāriqah",
            'AE-DU' => "Dubayy",
            'AE-RK' => "Ra’s al Khaymah",
            'AE-UQ' => "Umm al Qaywayn",
        ],
        "United Kingdom"       => [
            'GB-ABE' => "Aberdeen City",
            'GB-ABD' => "Aberdeenshire",
            'GB-ANS' => "Angus",
            'GB-ANT' => "Antrim",
            'GB-ARD' => "Ards",
            'GB-AGB' => "Argyll and Bute",
            'GB-ARM' => "Armagh",
            'GB-BLA' => "Ballymena",
            'GB-BLY' => "Ballymoney",
            'GB-BNB' => "Banbridge",
            'GB-BDG' => "Barking and Dagenham",
            'GB-BNE' => "Barnet",
            'GB-BNS' => "Barnsley",
            'GB-BAS' => "Bath and North East Somerset",
            'GB-BDF' => "Bedford",
            'GB-BFS' => "Belfast",
            'GB-BEX' => "Bexley",
            'GB-BIR' => "Birmingham",
            'GB-BBD' => "Blackburn with Darwen",
            'GB-BPL' => "Blackpool",
            'GB-BGW' => "Blaenau Gwent",
            'GB-BOL' => "Bolton",
            'GB-BMH' => "Bournemouth",
            'GB-BRC' => "Bracknell Forest",
            'GB-BRD' => "Bradford",
            'GB-BEN' => "Brent",
            'GB-BGE' => "Bridgend (Pen-y-bont ar Ogwr)",
            'GB-BNH' => "Brighton and Hove",
            'GB-BST' => "Bristol, City of",
            'GB-BRY' => "Bromley",
            'GB-BKM' => "Buckinghamshire",
            'GB-BUR' => "Bury",
            'GB-CAY' => "Caerphilly (Caerffili)",
            'GB-CLD' => "Calderdale",
            'GB-CAM' => "Cambridgeshire",
            'GB-CMD' => "Camden",
            'GB-CRF' => "Cardiff (Caerdydd)",
            'GB-CMN' => "Carmarthenshire (Sir Gaerfyrddin)",
            'GB-CKF' => "Carrickfergus",
            'GB-CSR' => "Castlereagh",
            'GB-CBF' => "Central Bedfordshire",
            'GB-CGN' => "Ceredigion (Sir Ceredigion)",
            'GB-CHE' => "Cheshire East",
            'GB-CHW' => "Cheshire West and Chester",
            'GB-CLK' => "Clackmannanshire",
            'GB-CLR' => "Coleraine",
            'GB-CWY' => "Conwy",
            'GB-CKT' => "Cookstown",
            'GB-CON' => "Cornwall",
            'GB-COV' => "Coventry",
            'GB-CGV' => "Craigavon",
            'GB-CRY' => "Croydon",
            'GB-CMA' => "Cumbria",
            'GB-DAL' => "Darlington",
            'GB-DEN' => "Denbighshire (Sir Ddinbych)",
            'GB-DER' => "Derby",
            'GB-DBY' => "Derbyshire",
            'GB-DRY' => "Derry",
            'GB-DEV' => "Devon",
            'GB-DNC' => "Doncaster",
            'GB-DOR' => "Dorset",
            'GB-DOW' => "Down",
            'GB-DUD' => "Dudley",
            'GB-DGY' => "Dumfries and Galloway",
            'GB-DND' => "Dundee City",
            'GB-DGN' => "Dungannon",
            'GB-DUR' => "Durham",
            'GB-EAL' => "Ealing",
            'GB-EAY' => "East Ayrshire",
            'GB-EDU' => "East Dunbartonshire",
            'GB-ELN' => "East Lothian",
            'GB-ERW' => "East Renfrewshire",
            'GB-ERY' => "East Riding of Yorkshire",
            'GB-ESX' => "East Sussex",
            'GB-EDH' => "Edinburgh, City of",
            'GB-ELS' => "Eilean Siar",
            'GB-ENF' => "Enfield",
            'GB-ENG' => "England",
            'GB-EAW' => "England and Wales",
            'GB-ESS' => "Essex",
            'GB-FAL' => "Falkirk",
            'GB-FER' => "Fermanagh",
            'GB-FIF' => "Fife",
            'GB-FLN' => "Flintshire (Sir y Fflint)",
            'GB-GAT' => "Gateshead",
            'GB-GLG' => "Glasgow City",
            'GB-GLS' => "Gloucestershire",
            'GB-GBN' => "Great Britain",
            'GB-GRE' => "Greenwich",
            'GB-GWN' => "Gwynedd",
            'GB-HCK' => "Hackney",
            'GB-HAL' => "Halton",
            'GB-HMF' => "Hammersmith and Fulham",
            'GB-HAM' => "Hampshire",
            'GB-HRY' => "Haringey",
            'GB-HRW' => "Harrow",
            'GB-HPL' => "Hartlepool",
            'GB-HAV' => "Havering",
            'GB-HEF' => "Herefordshire",
            'GB-HRT' => "Hertfordshire",
            'GB-HLD' => "Highland",
            'GB-HIL' => "Hillingdon",
            'GB-HNS' => "Hounslow",
            'GB-IVC' => "Inverclyde",
            'GB-AGY' => "Isle of Anglesey (Sir Ynys Môn)",
            'GB-IOW' => "Isle of Wight",
            'GB-ISL' => "Islington",
            'GB-KEC' => "Kensington and Chelsea",
            'GB-KEN' => "Kent",
            'GB-KHL' => "Kingston upon Hull",
            'GB-KTT' => "Kingston upon Thames",
            'GB-KIR' => "Kirklees",
            'GB-KWL' => "Knowsley",
            'GB-LBH' => "Lambeth",
            'GB-LAN' => "Lancashire",
            'GB-LRN' => "Larne",
            'GB-LDS' => "Leeds",
            'GB-LCE' => "Leicester",
            'GB-LEC' => "Leicestershire",
            'GB-LEW' => "Lewisham",
            'GB-LMV' => "Limavady",
            'GB-LIN' => "Lincolnshire",
            'GB-LSB' => "Lisburn",
            'GB-LIV' => "Liverpool",
            'GB-LND' => "London, City of",
            'GB-LUT' => "Luton",
            'GB-MFT' => "Magherafelt",
            'GB-MAN' => "Manchester",
            'GB-MDW' => "Medway",
            'GB-MTY' => "Merthyr Tydfil (Merthyr Tudful)",
            'GB-MRT' => "Merton",
            'GB-MDB' => "Middlesbrough",
            'GB-MLN' => "Midlothian",
            'GB-MIK' => "Milton Keynes",
            'GB-MON' => "Monmouthshire (Sir Fynwy)",
            'GB-MRY' => "Moray",
            'GB-MYL' => "Moyle",
            'GB-NTL' => "Neath Port Talbot (Castell-nedd Port Talbot)",
            'GB-NET' => "Newcastle upon Tyne",
            'GB-NWM' => "Newham",
            'GB-NWP' => "Newport (Casnewydd)",
            'GB-NYM' => "Newry and Mourne",
            'GB-NTA' => "Newtownabbey",
            'GB-NFK' => "Norfolk",
            'GB-NAY' => "North Ayrshire",
            'GB-NDN' => "North Down",
            'GB-NEL' => "North East Lincolnshire",
            'GB-NLK' => "North Lanarkshire",
            'GB-NLN' => "North Lincolnshire",
            'GB-NSM' => "North Somerset",
            'GB-NTY' => "North Tyneside",
            'GB-NYK' => "North Yorkshire",
            'GB-NTH' => "Northamptonshire",
            'GB-NIR' => "Northern Ireland",
            'GB-NBL' => "Northumberland",
            'GB-NGM' => "Nottingham",
            'GB-NTT' => "Nottinghamshire",
            'GB-OLD' => "Oldham",
            'GB-OMH' => "Omagh",
            'GB-ORK' => "Orkney Islands",
            'GB-OXF' => "Oxfordshire",
            'GB-PEM' => "Pembrokeshire (Sir Benfro)",
            'GB-PKN' => "Perth and Kinross",
            'GB-PTE' => "Peterborough",
            'GB-PLY' => "Plymouth",
            'GB-POL' => "Poole",
            'GB-POR' => "Portsmouth",
            'GB-POW' => "Powys",
            'GB-RDG' => "Reading",
            'GB-RDB' => "Redbridge",
            'GB-RCC' => "Redcar and Cleveland",
            'GB-RFW' => "Renfrewshire",
            'GB-RCT' => "Rhondda, Cynon, Taff (Rhondda, Cynon, Taf)",
            'GB-RIC' => "Richmond upon Thames",
            'GB-RCH' => "Rochdale",
            'GB-ROT' => "Rotherham",
            'GB-RUT' => "Rutland",
            'GB-SLF' => "Salford",
            'GB-SAW' => "Sandwell",
            'GB-SCT' => "Scotland",
            'GB-SCB' => "Scottish Borders, The",
            'GB-SFT' => "Sefton",
            'GB-SHF' => "Sheffield",
            'GB-ZET' => "Shetland Islands",
            'GB-SHR' => "Shropshire",
            'GB-SLG' => "Slough",
            'GB-SOL' => "Solihull",
            'GB-SOM' => "Somerset",
            'GB-SAY' => "South Ayrshire",
            'GB-SGC' => "South Gloucestershire",
            'GB-SLK' => "South Lanarkshire",
            'GB-STY' => "South Tyneside",
            'GB-STH' => "Southampton",
            'GB-SOS' => "Southend-on-Sea",
            'GB-SWK' => "Southwark",
            'GB-SHN' => "St. Helens",
            'GB-STS' => "Staffordshire",
            'GB-STG' => "Stirling",
            'GB-SKP' => "Stockport",
            'GB-STT' => "Stockton-on-Tees",
            'GB-STE' => "Stoke-on-Trent",
            'GB-STB' => "Strabane",
            'GB-SFK' => "Suffolk",
            'GB-SND' => "Sunderland",
            'GB-SRY' => "Surrey",
            'GB-STN' => "Sutton",
            'GB-SWA' => "Swansea (Abertawe)",
            'GB-SWD' => "Swindon",
            'GB-TAM' => "Tameside",
            'GB-TFW' => "Telford and Wrekin",
            'GB-THR' => "Thurrock",
            'GB-TOB' => "Torbay",
            'GB-TOF' => "Torfaen (Tor-faen)",
            'GB-TWH' => "Tower Hamlets",
            'GB-TRF' => "Trafford",
            'GB-UKM' => "United Kingdom",
            'GB-VGL' => "Vale of Glamorgan, The (Bro Morgannwg)",
            'GB-WKF' => "Wakefield",
            'GB-WLS' => "Wales",
            'GB-WLL' => "Walsall",
            'GB-WFT' => "Waltham Forest",
            'GB-WND' => "Wandsworth",
            'GB-WRT' => "Warrington",
            'GB-WAR' => "Warwickshire",
            'GB-WBK' => "West Berkshire",
            'GB-WDU' => "West Dunbartonshire",
            'GB-WLN' => "West Lothian",
            'GB-WSX' => "West Sussex",
            'GB-WSM' => "Westminster",
            'GB-WGN' => "Wigan",
            'GB-WNM' => "Windsor and Maidenhead",
            'GB-WRL' => "Wirral",
            'GB-WOK' => "Wokingham",
            'GB-WLV' => "Wolverhampton",
            'GB-WOR' => "Worcestershire",
            'GB-WRX' => "Wrexham (Wrecsam)",
            'GB-YOR' => "York",
        ],
        "United States"        => [
            'US-AL' => "Alabama",
            'US-AK' => "Alaska",
            'US-AS' => "American Samoa, Samoa Americana",
            'US-AZ' => "Arizona",
            'US-AR' => "Arkansas",
            'US-CA' => "California",
            'US-CO' => "Colorado",
            'US-CT' => "Connecticut",
            'US-DE' => "Delaware",
            'US-DC' => "District of Columbia, Disricte de Columbia",
            'US-FL' => "Florida",
            'US-GA' => "Georgia, Geòrgia",
            'US-GU' => "Guam",
            'US-HI' => "Hawaii",
            'US-ID' => "Idaho",
            'US-IL' => "Illinois",
            'US-IN' => "Indiana",
            'US-IA' => "Iowa",
            'US-KS' => "Kansas",
            'US-KY' => "Kentucky",
            'US-LA' => "Louisiana",
            'US-ME' => "Maine",
            'US-MD' => "Maryland",
            'US-MA' => "Massachusetts",
            'US-MI' => "Michigan",
            'US-MN' => "Minnesota",
            'US-MS' => "Mississippi",
            'US-MO' => "Missouri",
            'US-MT' => "Montana",
            'US-NE' => "Nebraska",
            'US-NV' => "Nevada",
            'US-NH' => "New Hampshire",
            'US-NJ' => "New Jersey",
            'US-NM' => "New Mexico",
            'US-NY' => "New York",
            'US-NC' => "North Carolina",
            'US-ND' => "North Dakota",
            'US-MP' => "Northern Mariana Islands, Illes Marianes del Nord",
            'US-OH' => "Ohio",
            'US-OK' => "Oklahoma",
            'US-OR' => "Oregon",
            'US-PA' => "Pennsylvania",
            'US-PR' => "Puerto Rico",
            'US-RI' => "Rhode Island",
            'US-SC' => "South Carolina",
            'US-SD' => "South Dakota",
            'US-TN' => "Tennessee",
            'US-TX' => "Texas",
            'US-UM' => "United States Minor Outlying Islands, Illes Perifèriques Menors dels EUA",
            'US-UT' => "Utah",
            'US-VT' => "Vermont",
            'US-VI' => "Virgin Islands, Illes Verge",
            'US-VA' => "Virginia",
            'US-WA' => "Washington",
            'US-WV' => "West Virginia",
            'US-WI' => "Wisconsin",
            'US-WY' => "Wyoming",
        ],
        "Vietnam"              => [
            'VN-44' => "An Giang",
            'VN-43' => "Bà Rịa - Vũng Tàu",
            'VN-57' => "Bình Dương",
            'VN-58' => "Bình Phước",
            'VN-40' => "Bình Thuận",
            'VN-31' => "Bình Định",
            'VN-55' => "Bạc Liêu",
            'VN-54' => "Bắc Giang",
            'VN-53' => "Bắc Kạn",
            'VN-56' => "Bắc Ninh",
            'VN-50' => "Bến Tre",
            'VN-04' => "Cao Bằng",
            'VN-59' => "Cà Mau",
            'VN-48' => "Cần Thơ",
            'VN-30' => "Gia Lai",
            'VN-14' => "Hoà Bình",
            'VN-03' => "Hà Giang",
            'VN-63' => "Hà Nam",
            'VN-64' => "Hà Nội, thủ đô",
            'VN-15' => "Hà Tây",
            'VN-23' => "Hà Tỉnh",
            'VN-66' => "Hưng Yên",
            'VN-61' => "Hải Duong",
            'VN-62' => "Hải Phòng, thành phố",
            'VN-73' => "Hậu Giang",
            'VN-65' => "Hồ Chí Minh, thành phố [Sài Gòn]",
            'VN-34' => "Khánh Hòa",
            'VN-47' => "Kiên Giang",
            'VN-28' => "Kon Tum",
            'VN-01' => "Lai Châu",
            'VN-41' => "Long An",
            'VN-02' => "Lào Cai",
            'VN-35' => "Lâm Đồng",
            'VN-09' => "Lạng Sơn",
            'VN-67' => "Nam Định",
            'VN-22' => "Nghệ An",
            'VN-18' => "Ninh Bình",
            'VN-36' => "Ninh Thuận",
            'VN-68' => "Phú Thọ",
            'VN-32' => "Phú Yên",
            'VN-24' => "Quảng Bình",
            'VN-27' => "Quảng Nam",
            'VN-29' => "Quảng Ngãi",
            'VN-13' => "Quảng Ninh",
            'VN-25' => "Quảng Trị",
            'VN-52' => "Sóc Trăng",
            'VN-05' => "Sơn La",
            'VN-21' => "Thanh Hóa",
            'VN-20' => "Thái Bình",
            'VN-69' => "Thái Nguyên",
            'VN-26' => "Thừa Thiên-Huế",
            'VN-46' => "Tiền Giang",
            'VN-51' => "Trà Vinh",
            'VN-07' => "Tuyên Quang",
            'VN-37' => "Tây Ninh",
            'VN-49' => "Vĩnh Long",
            'VN-70' => "Vĩnh Phúc",
            'VN-06' => "Yên Bái",
            'VN-71' => "Điện Biên",
            'VN-60' => "Đà Nẵng, thành phố",
            'VN-33' => "Đắc Lắk",
            'VN-72' => "Đắk Nông",
            'VN-39' => "Đồng Nai",
            'VN-45' => "Đồng Tháp",
        ],
    ];

    protected function getInput()
    {
        if ($this->get('group') == 'regions')
        {
            $this->use_tree_select = true;
        }

        return parent::getInput();
    }

    protected function getListOptions($attributes)
    {
        $options = [];

        foreach ($this->{$attributes['group']} as $key => $val)
        {
            if (is_array($val))
            {
                $option              = $this->getOption($key, $key);
                $option->level       = 0;
                $option->heading     = true;
                $option->no_checkbox = true;

                $options[] = $option;

                foreach ($val as $sub_key => $sub_val)
                {
                    $option        = $this->getOption($sub_key, $sub_val);
                    $option->level = 1;

                    $options[] = $option;
                }

                continue;
            }

            $option        = $this->getOption($key, $val);
            $option->level = 0;

            $options[] = $option;
        }

        return $options;
    }

    protected function getOption($key, $val)
    {
        if ( ! $val)
        {
            return JHtml::_('select.option', '-', '&nbsp;', 'value', 'text', true);
        }

        if ($key[0] == '-')
        {
            return JHtml::_('select.option', '-', $val, 'value', 'text', true);
        }

        $val    = RL_Form::prepareSelectItem($val);
        $option = JHtml::_('select.option', $key, $val);

        return $option;
    }

    private function cleanRegions($regions)
    {
        $regions = str_replace('"', '', $regions);

        $regions = htmlspecialchars($regions);

        // LR,MY, name for US-MD,Maryland,Maryland
        // >>
        // LR,MY,Maryland,Maryland
        // US,MD,Maryland,Maryland
        $regex = '(\n[^,]*),([^\n]*), name for ([^-]*)-([^,]*),([^\n]*\n)';
        RL_RegEx::match($regex, $regions, $match);

        while ($match)
        {
            $regions = RL_RegEx::replace($regex, '\1,\2,\5\3,\4,\5', $regions);

            RL_RegEx::match($regex, $regions, $match);
        }

        // LR,MY,Maryland,Maryland
        // >>
        // LR,MY,Maryland
        $regions = RL_RegEx::replace('(\n[^,]*,[^,]*),([^,]*),\2', '\1,\2', $regions);

        // LR,MY,District of Columbia,Disricte de Columbia
        // >>
        // LR, MY, District of Columbia, Disricte de Columbia
        $regions = str_replace(',', ', ', $regions);

        // GB, WRX, Wrexham;Wrecsam
        // >>
        // GB, WRX, Wrexham (Wrecsam)
        $regions = RL_RegEx::replace('(\n[^,]*,[^,]*,[^;]*);([^\n]*)', '\1 (\2)', $regions);

        $regions = trim(RL_RegEx::replace('  +', ' ', $regions));

        return explode("\n", $regions);
    }

    private function getRegionArray()
    {
        $regions = $this->getRegionArrayByFile();
        $regions = $this->cleanRegions($regions);

        $by_country = [];

        foreach ($regions as $full_region)
        {
            if (empty($full_region))
            {
                continue;
            }

            [$code_c, $code_r, $region] = explode(',', $full_region, 3);

            $code_c = trim($code_c);
            $code_r = trim($code_r);
            $region = trim($region);

            if ( ! isset($this->region_countries[$code_c]))
            {
                continue;
            }

            $country = $this->countries[$code_c];

            if ( ! isset($by_country[$code_c]))
            {
                $by_country[$code_c] = [];
            }

            $name = $this->getRegionName($country, $region);

            $by_country[$code_c][$region] = '\'' . $code_c . '-' . $code_r . '\'  => "' . $name . '",';
        }

        $min_regions = 3;

        $output = [];

        foreach ($this->region_countries as $code_c => $country)
        {
            if ( ! isset($by_country[$code_c]))
            {
                continue;
            }

            $regions = $by_country[$code_c];

            if (count($regions) < $min_regions)
            {
                continue;
            }

            ksort($regions);

            if (empty($output))
            {
                $output[] = '\'-' . $code_c . '\'  => "' . $country . '",';
                $output[] = implode("\n", $regions);

                continue;
            }

            $output[] = '';
            $output[] = '\'--' . $code_c . '\'  => "", \'-' . $code_c . '\'  => "' . $country . '",';
            $output[] = implode("\n", $regions);
        }

        echo implode("\n", $output);

        exit;
    }

    private function getRegionArrayByFile()
    {
        // https://www.softcatala.org/wiki/ISO_3166_2
        return trim(file_get_contents(__DIR__ . '/geo.iso.regions.txt'));
    }

    private function getRegionName($country, $region)
    {
        switch ($country . ': ' . $region)
        {
            case 'Mexico: Distrito Federal':
                return 'Mexico: Distrito Federal (Mexico City)';

            default:
                return $country . ': ' . $region;
        }
    }
    /* <<< [NONE] <<< */
}
