<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

use RegularLabs\Library\ActionLogPlugin as RL_ActionLogPlugin;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Extension as RL_Extension;

defined('_JEXEC') or die;

if ( ! is_file(JPATH_LIBRARIES . '/regularlabs/regularlabs.xml')
    || ! class_exists('RegularLabs\Library\Parameters')
    || ! class_exists('RegularLabs\Library\DownloadKey')
    || ! class_exists('RegularLabs\Library\ActionLogPlugin')
)
{
    return;
}

if ( ! RL_Document::isJoomlaVersion(4))
{
    RL_Extension::disable('rereplacer', 'plugin', 'actionlog');

    return;
}

if (true)
{
    class PlgActionlogReReplacer extends RL_ActionLogPlugin
    {
        public $name  = 'REREPLACER';
        public $alias = 'rereplacer';

        public function __construct(&$subject, array $config = [])
        {
            parent::__construct($subject, $config);

            $this->addItem('com_rereplacer', 'item', 'RR_ITEM');
        }
    }
}
