<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\Language\Text as JText;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Extension as RL_Extension;
use RegularLabs\Library\StringReplacer as RL_StringReplacer;
use RegularLabs\Library\SystemPlugin as RL_SystemPlugin;
use RegularLabs\Plugin\System\ReReplacer\Replace;
use RegularLabs\Plugin\System\ReReplacer\Tag;

if ( ! is_file(JPATH_LIBRARIES . '/regularlabs/regularlabs.xml')
    || ! class_exists('RegularLabs\Library\Parameters')
    || ! class_exists('RegularLabs\Library\DownloadKey')
    || ! class_exists('RegularLabs\Library\SystemPlugin')
)
{
    JFactory::getLanguage()->load('plg_system_rereplacer', __DIR__);
    JFactory::getApplication()->enqueueMessage(
        JText::sprintf('RR_EXTENSION_CAN_NOT_FUNCTION', JText::_('REREPLACER'))
        . ' ' . JText::_('RR_REGULAR_LABS_LIBRARY_NOT_INSTALLED'),
        'error'
    );

    return;
}

if ( ! RL_Document::isJoomlaVersion(4, 'REREPLACER'))
{
    RL_Extension::disable('rereplacer', 'plugin');

    RL_Document::adminError(
        JText::sprintf('RL_PLUGIN_HAS_BEEN_DISABLED', JText::_('REREPLACER'))
    );

    return;
}

if (true)
{
    class PlgSystemReReplacer extends RL_SystemPlugin
    {
        public $_lang_prefix        = 'RR';
        public $_enable_in_admin    = true;
        public $_can_disable_by_url = false;
        public $_jversion           = 4;

        protected function extraChecks()
        {
            // return if component is not installed
            if ( ! file_exists(JPATH_ADMINISTRATOR . '/components/com_rereplacer/rereplacer.xml'))
            {
                return false;
            }

            // don't allow ReReplacer if current page is the ReReplacer administrator page
            if (JFactory::getApplication()->input->get('option', '') == 'com_rereplacer')
            {
                return false;
            }

            return parent::extraChecks();
        }

        protected function handleOnContentPrepare($area, $context, &$article, &$params, $page = 0)
        {
            Replace::replaceInArticle($article, $context);

            return false;
        }

        protected function changeDocumentBuffer(&$buffer)
        {
            return Tag::tagArea($buffer, 'component');
        }

        protected function changeFinalHtmlOutput(&$html)
        {
            Replace::replaceInAreas($html);

            return true;
        }

        protected function cleanFinalHtmlOutput(&$html)
        {
            $html = new RL_StringReplacer($html);

            $html->replaceRegex('<\!-- (START|END): RR_[^>]* -->', '');

            // Remove any leftover protection tags
            if ($html->contains('{noreplace}'))
            {
                $html->excludeForm()
                    ->replace(['{noreplace}', '{/noreplace}'], '');
            }

            $html = $html->toString();
        }
    }
}
