<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Plugin\System\ReReplacer;

defined('_JEXEC') or die;

use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\RegEx as RL_RegEx;
use RegularLabs\Library\StringReplacer as RL_StringReplacer;

class StringReplacer
{
    public static function get($string, object $settings)
    {
        $replacer = new RL_StringReplacer($string);

        self::excludeForm($replacer, $settings);
        self::excludeNoReplaceTags($replacer);


        return $replacer;
    }

    private static function excludeForm(RL_StringReplacer $replacer, object $settings)
    {
        if ($settings->enable_in_edit_forms || ! RL_Document::isEditPage())
        {
            return;
        }

        $replacer->excludeForm();
    }

    private static function excludeHtmlTags(RL_StringReplacer $replacer, object $settings)
    {
    }

    private static function excludeNoReplaceTags(RL_StringReplacer $replacer)
    {
        if ( ! $replacer->contains('{noreplace}'))
        {
            return;
        }

        // Protect everything between the {noreplace} tags
        $replacer->excludeRegexBetween('(\{noreplace\})', '(\{/noreplace\})', true);
    }

    private static function excludeOutsideBetweenStrings(RL_StringReplacer $replacer, object $settings)
    {
    }

    private static function getHtmlTagsArrayFromString(string $string)
    {
        if (empty($string))
        {
            return [];
        }

        // removes unwanted whitespace from tag selection
        $string = RL_RegEx::replace('\s*(\[|\])\s*', '\1', $string);
        $string = RL_RegEx::replace('(\[[^\]]*)\s+', '\1', $string);
        // removes unwanted params from tag selection
        // (if an asterisk is set, all other params for that tag name are redundant)
        $string = RL_RegEx::replace('\[[^\]]*?\*[^\]]*\]', '[*]', $string);

        $string = str_replace(']', ']|||', $string);
        $string = trim($string, '|');

        $tags = explode('|||', $string);

        if (in_array('*', $tags) || in_array('*[*]', $tags))
        {
            return ['*'];
        }

        return $tags;
    }
}
