<?php
/**
 * @package         ReReplacer
 * @version         13.2.0
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            https://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         GNU General Public License version 2 or later
 */

namespace RegularLabs\Plugin\System\ReReplacer;

defined('_JEXEC') or die;

// Only used in Pro version
/* >>> [PRO] >>> */
use RegularLabs\Library\Variables as RL_Variables;

class Variables
{
    public static function replacePost(&$string, $sub_splitter = '')
    {
        if (empty($string))
        {
            return;
        }

        if ( ! $sub_splitter)
        {
            RL_Variables::replaceRandomTags($string);
            RL_Variables::replaceTextTags($string);
            RL_Variables::replaceTextConversionTags($string);

            return;
        }

        $parts = explode($sub_splitter, $string);

        foreach ($parts as $i => $part)
        {
            if ($i % 2 == 0)
            {
                continue;
            }

            self::replacePost($part);
            $parts[$i] = $part;
        }

        $string = implode('', $parts);
    }

    public static function replacePre(&$string, $article = null)
    {
        if (empty($string))
        {
            return;
        }

        RL_Variables::replaceArticleTags($string, $article);
        RL_Variables::replaceUserTags($string);
        RL_Variables::replaceDateTags($string);
    }
}
